/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.BeanUtils;
import ch.systemsx.cisd.lims.base.ObservableType;
import ch.systemsx.cisd.lims.server.business.AbstractManager;
import ch.systemsx.cisd.lims.server.business.IObservableTypeManager;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.ObservableTypeDTO;
import java.util.List;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.transaction.annotation.Transactional;

final class ObservableTypeManager
extends AbstractManager
implements IObservableTypeManager {
    ObservableTypeManager(IDAOFactory daoFactory, StrategyFactoryProvider strategyProvider, IBusinessObjectFactory boFactory) {
        super(daoFactory, strategyProvider, boFactory);
    }

    @Transactional
    public ObservableType[] listObservableTypes() {
        List<ObservableTypeDTO> list = this.daoFactory.getObservableTypeDAO().listObservableTypes();
        return BeanUtils.createBeanList(ObservableType.class, list).toArray(new ObservableType[list.size()]);
    }

    @Transactional
    public void registerObservableType(String observableTypeCode, String observableTypeDescription) {
        ParameterChecker.checkIfNotNull(observableTypeCode, "observable type code");
        ObservableTypeDTO observableType = new ObservableTypeDTO();
        observableType.setCode(observableTypeCode);
        observableType.setDescription(observableTypeDescription);
        try {
            this.daoFactory.getObservableTypeDAO().createType(observableType);
        }
        catch (DataIntegrityViolationException ex) {
            throw UserFailureException.fromTemplate("Observable type with code '%s' already exists in the database.", new Object[]{observableTypeCode, ex});
        }
    }
}

