/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.InvalidationFiller;
import ch.systemsx.cisd.lims.server.business.bo.ProcedureFiller;
import ch.systemsx.cisd.lims.server.business.bo.SampleHierarchyFiller;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IExternalDataDAO;
import ch.systemsx.cisd.lims.server.dataaccess.IProcedureDAO;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.lims.server.dto.ExternalDataDTO;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractProcedureBusinessObject
extends AbstractBusinessObject {
    AbstractProcedureBusinessObject(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    protected final void enrichWithSamplesAndData(ProcedureDTO procedure) {
        this.enrichWithScreenableSamples(procedure);
        this.enrichSamplesWithData(procedure);
    }

    protected final void enrichWithScreenableSamples(ProcedureDTO procedure) {
        ISampleDAO sampleDAO = this.getSampleDAO();
        List<SampleDTO> samples = this.listScreenablePlates(sampleDAO, procedure.getId());
        SampleHierarchyFiller.enrichWithFullHierarchy(samples, sampleDAO);
        InvalidationFiller.enrichParentAndTopWithInvalidation(this.getInvalidationDAO(), samples.toArray(SampleDTO.EMPTY_ARRAY));
        procedure.setResultSamples(samples.toArray(SampleDTO.EMPTY_ARRAY));
    }

    protected final void enrichWithControlLayout(ProcedureDTO procedure) {
        List<SampleDTO> controlLayoutPlates = this.getControlLayoutPlates(procedure.getId());
        procedure.setInputSamples(controlLayoutPlates.toArray(SampleDTO.EMPTY_ARRAY));
    }

    private void enrichSamplesWithData(ProcedureDTO procedure) {
        IProcedureDAO procedureDAO = this.getProcedureDAO();
        List<ProcedureDTO> allProcedures = procedureDAO.listProcedures(procedure.getExperimentID());
        SampleDTO[] sampleDTOArray = procedure.getResultSamples();
        int n = sampleDTOArray.length;
        int n2 = 0;
        while (n2 < n) {
            SampleDTO sample = sampleDTOArray[n2];
            this.enrichSampleWithData(sample, allProcedures);
            ++n2;
        }
    }

    private void enrichSampleWithData(SampleDTO sample, List<ProcedureDTO> allProcedures) {
        IExternalDataDAO externalDataDAO = this.getExternalDataDAO();
        Long sampleId = sample.getId();
        List<ExternalDataDTO> list = this.listExternalData(sampleId, IExternalDataDAO.SourceType.MEASUREMENT, externalDataDAO, allProcedures);
        sample.setMeasurementData(list.toArray(ExternalDataDTO.EMPTY_ARRAY));
        list = this.listExternalData(sampleId, IExternalDataDAO.SourceType.DERIVED, externalDataDAO, allProcedures);
        sample.setDerivedData(list.toArray(ExternalDataDTO.EMPTY_ARRAY));
    }

    private List<ExternalDataDTO> listExternalData(Long sampleId, IExternalDataDAO.SourceType sourceType, IExternalDataDAO externalDataDAO, List<ProcedureDTO> allProcedures) {
        List<ExternalDataDTO> list = externalDataDAO.listExternalData(sampleId, sourceType);
        ProcedureFiller.fillProcedureFor(list, allProcedures);
        return list;
    }

    private final List<SampleDTO> getControlLayoutPlates(long procedureId) {
        return this.getSampleDAO().listSamplesAsInputs(procedureId, SampleTypeCode.CONTROL_LAYOUT.getCode());
    }

    private final List<SampleDTO> listScreenablePlates(ISampleDAO sampleDAO, long procedureId) {
        List<SampleDTO> screenablePlates = sampleDAO.listSamplesAsInputs(procedureId);
        return this.stripControlLayoutSamples(screenablePlates);
    }

    private List<SampleDTO> stripControlLayoutSamples(List<SampleDTO> screenablePlates) {
        int i = 0;
        while (i < screenablePlates.size()) {
            assert (screenablePlates.get(i) != null);
            assert (screenablePlates.get(i).getSampleType() != null);
            if (SampleTypeCode.CONTROL_LAYOUT.getCode().equals(screenablePlates.get(i).getSampleType().getCode())) {
                screenablePlates.remove(i);
            }
            ++i;
        }
        return screenablePlates;
    }
}

