/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.InvalidationFiller;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.IProcedureHolder;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import ch.systemsx.cisd.lims.server.dto.SampleTypeDTO;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSampleBusinessObject
extends AbstractBusinessObject {
    AbstractSampleBusinessObject(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    final void enrichParentAndTopWithInvalidation(SampleDTO ... samples) {
        InvalidationFiller.enrichParentAndTopWithInvalidation(this.getInvalidationDAO(), samples);
    }

    final SampleTypeDTO getSampleType(String code) throws UserFailureException {
        SampleTypeDTO sampleType = this.getSampleTypeDAO().tryFindSampleTypeByCode(code);
        if (sampleType == null) {
            throw UserFailureException.fromTemplate("No sample type with code '%s' could be found in the database.", code);
        }
        return sampleType;
    }

    final void enrichWithProcedure(IProcedureHolder procedureHolder, List<ProcedureDTO> procedures) {
        assert (procedureHolder != null) : "Unspecified procedure holder.";
        assert (procedures != null && procedures.size() > 0) : "Unspecified procedures.";
        ProcedureDTO procedure = this.tryGetValidProcedure(procedures);
        if (procedure != null) {
            procedureHolder.setProcedure(procedure);
        }
    }

    private final ProcedureDTO tryGetValidProcedure(List<ProcedureDTO> procedures) {
        ProcedureDTO foundProcedure = null;
        for (ProcedureDTO procedure : procedures) {
            if (procedure.getExperiment().getInvalidationId() != null) continue;
            if (foundProcedure != null) {
                throw UserFailureException.fromTemplate("Expected exactly one valid procedure, but found %d: %s", procedures.size(), procedures);
            }
            foundProcedure = procedure;
        }
        return foundProcedure;
    }
}

