/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.server.business.IScreeningProcessStrategy;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.StrategyFactoryProvider;
import ch.systemsx.cisd.lims.server.business.bo.BasicSampleBO;
import ch.systemsx.cisd.lims.server.business.bo.EntityPropertiesBO;
import ch.systemsx.cisd.lims.server.business.bo.EntityPropertiesConverter;
import ch.systemsx.cisd.lims.server.business.bo.EntityPropertyTypeTable;
import ch.systemsx.cisd.lims.server.business.bo.ExperimentBO;
import ch.systemsx.cisd.lims.server.business.bo.ExperimentTable;
import ch.systemsx.cisd.lims.server.business.bo.ExternalDataBO;
import ch.systemsx.cisd.lims.server.business.bo.IBasicSampleBO;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertiesBO;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertiesConverter;
import ch.systemsx.cisd.lims.server.business.bo.IEntityPropertyTypeTable;
import ch.systemsx.cisd.lims.server.business.bo.IExperimentBO;
import ch.systemsx.cisd.lims.server.business.bo.IExperimentTable;
import ch.systemsx.cisd.lims.server.business.bo.IExternalDataBO;
import ch.systemsx.cisd.lims.server.business.bo.IMaterialTable;
import ch.systemsx.cisd.lims.server.business.bo.IPersonBO;
import ch.systemsx.cisd.lims.server.business.bo.IProcedureBO;
import ch.systemsx.cisd.lims.server.business.bo.IProcedureTable;
import ch.systemsx.cisd.lims.server.business.bo.IProcessingInstructionTable;
import ch.systemsx.cisd.lims.server.business.bo.IProjectBO;
import ch.systemsx.cisd.lims.server.business.bo.IPropertyTypeTable;
import ch.systemsx.cisd.lims.server.business.bo.IPropertyValueProviderFactory;
import ch.systemsx.cisd.lims.server.business.bo.ISampleBO;
import ch.systemsx.cisd.lims.server.business.bo.ISampleComponentTable;
import ch.systemsx.cisd.lims.server.business.bo.ISampleTable;
import ch.systemsx.cisd.lims.server.business.bo.ISampleTree;
import ch.systemsx.cisd.lims.server.business.bo.MaterialTable;
import ch.systemsx.cisd.lims.server.business.bo.PersonBO;
import ch.systemsx.cisd.lims.server.business.bo.ProcedureBO;
import ch.systemsx.cisd.lims.server.business.bo.ProcedureTable;
import ch.systemsx.cisd.lims.server.business.bo.ProcessingInstructionTable;
import ch.systemsx.cisd.lims.server.business.bo.ProjectBO;
import ch.systemsx.cisd.lims.server.business.bo.PropertyTypeTable;
import ch.systemsx.cisd.lims.server.business.bo.SampleBO;
import ch.systemsx.cisd.lims.server.business.bo.SampleComponentTable;
import ch.systemsx.cisd.lims.server.business.bo.SampleTable;
import ch.systemsx.cisd.lims.server.business.bo.SampleTree;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;

public class BusinessObjectFactory
implements IBusinessObjectFactory {
    private final IDAOFactory daoFactory;
    private final StrategyFactoryProvider provider;
    private final IPropertyValueProviderFactory valueProviderFactory;

    public BusinessObjectFactory(IDAOFactory daoFactory, IPropertyValueProviderFactory valueProviderFactory, StrategyFactoryProvider provider) {
        this.valueProviderFactory = valueProviderFactory;
        this.provider = provider;
        assert (daoFactory != null) : "Unspecified DAO Factory";
        this.daoFactory = daoFactory;
    }

    private IScreeningProcessStrategy createProcessStrategy(Session session) {
        return this.provider.getFactory(session.getGroupId()).createScreeningProcessStrategy(this.daoFactory, this, session);
    }

    public IMaterialTable createMaterialTable(Session session) {
        IEntityPropertiesConverter converter = this.createEntityPropertiesConverter(EntityKind.MATERIAL);
        return new MaterialTable(this.daoFactory, converter, session);
    }

    public IExperimentTable createExperimentTable(Session session) {
        return new ExperimentTable(this.daoFactory, session);
    }

    public IExperimentBO createExperimentBO(Session session) {
        IEntityPropertiesConverter converter = this.createEntityPropertiesConverter(EntityKind.EXPERIMENT);
        return new ExperimentBO(this.daoFactory, this, this.createProcessStrategy(session), converter, session);
    }

    public IProcedureTable createProcedureTable(Session session) {
        return new ProcedureTable(this.daoFactory, session);
    }

    public IProcedureBO createProcedureBO(Session session) {
        return new ProcedureBO(this.daoFactory, session);
    }

    public IExternalDataBO createExternalDataBO(Session session) {
        return new ExternalDataBO(this.daoFactory, session);
    }

    public final IBasicSampleBO createBasicSampleBO(Session session) {
        return new BasicSampleBO(this.daoFactory, session);
    }

    public ISampleBO createSampleBO(Session session) {
        IEntityPropertiesConverter converter = this.createEntityPropertiesConverter(EntityKind.SAMPLE);
        return new SampleBO(this.daoFactory, converter, this.createProcessStrategy(session), session);
    }

    public ISampleTable createSampleTable(Session session) {
        return new SampleTable(this.daoFactory, session);
    }

    public ISampleTree createSampleTree(Session session) {
        return new SampleTree(this.daoFactory, session);
    }

    public ISampleComponentTable createSampleComponentTable(Session session) {
        return new SampleComponentTable(this.daoFactory, session);
    }

    public final IProjectBO createProjectBO(Session session) {
        return new ProjectBO(this.daoFactory, session);
    }

    public final IPersonBO createPersonBO(Session session) {
        return new PersonBO(this.daoFactory, session);
    }

    public IEntityPropertiesConverter createEntityPropertiesConverter(EntityKind entityKind) {
        return new EntityPropertiesConverter(entityKind, this.daoFactory);
    }

    public IEntityPropertiesBO createEntityPropertiesBO(EntityKind entityKind, Session session) {
        return new EntityPropertiesBO(entityKind, this.daoFactory, session, this.valueProviderFactory);
    }

    public final IPropertyTypeTable createPropertyTypeTable(Session session) {
        return new PropertyTypeTable(this.daoFactory, session);
    }

    public IEntityPropertyTypeTable createEntityPropertyTypeTable(Session session) {
        return new EntityPropertyTypeTable(this.daoFactory, session);
    }

    public IProcessingInstructionTable createProcessingInstructionTable(Session session) {
        return new ProcessingInstructionTable(this.daoFactory, session);
    }
}

