/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business.bo;

import ch.systemsx.cisd.common.collections.IKeyExtractor;
import ch.systemsx.cisd.common.collections.TableMap;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.server.business.ParameterChecker;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.AbstractBusinessObject;
import ch.systemsx.cisd.lims.server.business.bo.ISampleTree;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.lims.server.dto.InvalidationDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SampleTree
extends AbstractBusinessObject
implements ISampleTree {
    private final TableMap<Long, SampleDTO> samplesByID = new TableMap<Long, SampleDTO>(new IKeyExtractor<Long, SampleDTO>(){

        @Override
        public Long getKey(SampleDTO s) {
            return s.getId();
        }
    });

    SampleTree(IDAOFactory daoFactory, Session session) {
        super(daoFactory, session);
    }

    @Override
    public Iterator<SampleDTO> iterator() {
        return this.samplesByID.iterator();
    }

    @Override
    public void loadAndAddSampleAndDescendantsByCode(String sampleCode) {
        ParameterChecker.checkIfNotNull(sampleCode, "sample code");
        SampleDTO sample = this.getSampleDAO().tryFindSampleByCode(sampleCode);
        if (sample == null) {
            throw UserFailureException.fromTemplate("No sample with code '%s' could be found in the database.", sampleCode);
        }
        this.addSampleAndLoadSubTree(sample);
    }

    private void addSampleAndLoadSubTree(SampleDTO sample) {
        if (this.samplesByID.tryGet(sample.getId()) == null) {
            this.samplesByID.add(sample);
            List<SampleDTO> children = this.getSampleDAO().listSampleByGeneratedFrom(sample.getId());
            for (SampleDTO child : children) {
                this.addSampleAndLoadSubTree(child);
            }
        }
    }

    @Override
    public Collection<SampleDTO> invalidate(InvalidationDTO invalidation, String ... codesOfUninvalidatableSampleTypes) {
        assert (invalidation != null) : "Unspecified invalidation.";
        LinkedHashSet<SampleDTO> invalidatedSamples = new LinkedHashSet<SampleDTO>();
        HashSet<String> sampleTypeCodesOfUninvalidatable = new HashSet<String>();
        sampleTypeCodesOfUninvalidatable.addAll((Collection)Arrays.asList(codesOfUninvalidatableSampleTypes));
        for (SampleDTO sample : this.samplesByID) {
            if (sample.getInvalidationId() != null) continue;
            this.invalidate(sample, invalidation, sampleTypeCodesOfUninvalidatable, invalidatedSamples);
        }
        return invalidatedSamples;
    }

    private void invalidate(SampleDTO sample, InvalidationDTO invalidation, Set<String> sampleTypeCodesOfUninvalidatable, Set<SampleDTO> invalidatedSamples) {
        String sampleCode = sample.getCode();
        String sampleTypeCode = sample.getSampleType().getCode();
        if (sampleTypeCodesOfUninvalidatable.contains(sampleTypeCode)) {
            throw UserFailureException.fromTemplate("Cannot invalidate the sample '%s', it has a wrong type '%s'.", sampleCode, sampleTypeCode);
        }
        ISampleDAO sampleDAO = this.getSampleDAO();
        boolean updated = sampleDAO.updateSampleInvalidation(sample.getId(), invalidation.getId());
        if (!updated) {
            throw UserFailureException.fromTemplate("Sample '%s' is already invalid.", sampleCode);
        }
        sample.setInvalidation(invalidation);
        invalidatedSamples.add(sample);
    }
}

