/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.lims.server.dataaccess.ILocatorTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.LocatorTypeDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocatorTypeDAO
extends AbstractTypeDAO<LocatorTypeDTO>
implements ILocatorTypeDAO {
    private static final ParameterizedRowMapper<LocatorTypeDTO> LOCATOR_TYPE_ROW_MAPPER = new ParameterizedRowMapper<LocatorTypeDTO>(){

        public LocatorTypeDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            LocatorTypeDTO result = new LocatorTypeDTO();
            result.setId(rs.getLong("id"));
            result.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            result.setDescription(rs.getString("description"));
            return result;
        }
    };

    LocatorTypeDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper) {
        super(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
    }

    @Override
    protected final ParameterizedRowMapper<LocatorTypeDTO> getRowMapper() {
        return LOCATOR_TYPE_ROW_MAPPER;
    }

    @Override
    protected final String getTableName() {
        return "locator_types";
    }

    @Override
    public final LocatorTypeDTO tryFindLocatorTypeByCode(String code) throws DataAccessException {
        assert (code != null);
        return (LocatorTypeDTO)this.tryFindTypeByCode(code);
    }

    @Override
    public final List<LocatorTypeDTO> listLocatorTypes() throws DataAccessException {
        return this.listTypes();
    }
}

