/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.lims.server.dataaccess.IMaterialBatchDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.MaterialBatchDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

final class MaterialBatchDAO
extends AbstractDAO
implements IMaterialBatchDAO {
    private static final Logger operationExTrackingLog = LogFactory.getLogger(LogCategory.OPERATION, MaterialBatchDAO.class);
    private static final ParameterizedRowMapper<MaterialBatchDTO> MATERIAL_BATCH_ROW_MAPPER = new ParameterizedRowMapper<MaterialBatchDTO>(){

        public final MaterialBatchDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            MaterialBatchDTO materialBatch = new MaterialBatchDTO(null);
            materialBatch.setId(rs.getLong("id"));
            materialBatch.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            materialBatch.setAmount(rs.getDouble("amount"));
            materialBatch.setMaterialID(rs.getLong("mate_id"));
            return materialBatch;
        }
    };

    MaterialBatchDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler) {
        super(dataSource, dtoValidatorStore, sequencerHandler);
    }

    public final void createMaterialBatch(MaterialBatchDTO materialBatch) throws DataAccessException {
        assert (materialBatch != null) : "Missing material batch.";
        String code = materialBatch.getCode();
        assert (code != null) : "Missing material batch code.";
        Long materialID = materialBatch.getMaterialID();
        assert (materialID != null) : "Missing material id.";
        this.validateDTO(materialBatch);
        long id = this.getNextValueOf("MATERIAL_BATCH_ID_SEQ");
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        template.update("insert into material_batches (id, code, amount, mate_id, pers_id_registerer) values (?,?,?,?,?)", new Object[]{id, CodeConverter.tryToDatabase(code), materialBatch.getAmount(), materialID, materialBatch.getRegistratorID()});
        if (operationExTrackingLog.isInfoEnabled()) {
            operationExTrackingLog.info("ADD: material batch '" + code + "' for material id " + materialID);
        }
        materialBatch.setId(id);
    }

    public final Long tryFindMaterialBatchIdByCode(String code, long materialId) throws DataAccessException {
        return this.tryFindId("select id from material_batches where code = ? and mate_id = ?", CodeConverter.tryToDatabase(code), materialId);
    }

    public final MaterialBatchDTO getMaterialBatchForId(long materialBatchId) throws DataAccessException {
        return (MaterialBatchDTO)this.getSimpleJdbcTemplate().queryForObject("select * from material_batches where id = ?", MATERIAL_BATCH_ROW_MAPPER, new Object[]{materialBatchId});
    }
}

