/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.lims.server.dataaccess.IObservableTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.ObservableTypeDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ObservableTypeDAO
extends AbstractTypeDAO<ObservableTypeDTO>
implements IObservableTypeDAO {
    private static final ParameterizedRowMapper<ObservableTypeDTO> OBSERVABLE_TYPE_ROW_MAPPER = new ParameterizedRowMapper<ObservableTypeDTO>(){

        public ObservableTypeDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            ObservableTypeDTO result = new ObservableTypeDTO();
            result.setId(rs.getLong("id"));
            result.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            result.setDescription(rs.getString("description"));
            return result;
        }
    };

    ObservableTypeDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper) {
        super(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
    }

    @Override
    public ObservableTypeDTO tryFindObservableTypeByCode(String code) throws DataAccessException {
        return (ObservableTypeDTO)this.tryFindTypeByCode(code);
    }

    @Override
    public final List<ObservableTypeDTO> listObservableTypes() throws DataAccessException {
        return this.listTypes();
    }

    @Override
    protected final ParameterizedRowMapper<ObservableTypeDTO> getRowMapper() {
        return OBSERVABLE_TYPE_ROW_MAPPER;
    }

    @Override
    protected final String getTableName() {
        return "observable_types";
    }
}

