/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dataaccess.db;

import ch.systemsx.cisd.common.db.ISequenceNameMapper;
import ch.systemsx.cisd.common.db.ISequencerHandler;
import ch.systemsx.cisd.lims.server.dataaccess.IProcedureTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.AbstractTypeDAO;
import ch.systemsx.cisd.lims.server.dataaccess.db.CodeConverter;
import ch.systemsx.cisd.lims.server.dataaccess.db.DtoValidatorStore;
import ch.systemsx.cisd.lims.server.dto.ProcedureTypeDTO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcedureTypeDAO
extends AbstractTypeDAO<ProcedureTypeDTO>
implements IProcedureTypeDAO {
    private static final ParameterizedRowMapper<ProcedureTypeDTO> PROCEDURE_TYPE_ROW_MAPPER = new ParameterizedRowMapper<ProcedureTypeDTO>(){

        public ProcedureTypeDTO mapRow(ResultSet rs, int rowNum) throws SQLException {
            ProcedureTypeDTO result = new ProcedureTypeDTO();
            result.setId(rs.getLong("id"));
            result.setCode(CodeConverter.tryToBusinessLayer(rs.getString("code")));
            result.setDataAcquisition(rs.getBoolean("is_data_acquisition"));
            result.setDescription(rs.getString("description"));
            return result;
        }
    };

    ProcedureTypeDAO(DataSource dataSource, DtoValidatorStore dtoValidatorStore, ISequencerHandler sequencerHandler, ISequenceNameMapper sequenceNameMapper) {
        super(dataSource, dtoValidatorStore, sequencerHandler, sequenceNameMapper);
    }

    @Override
    public ProcedureTypeDTO tryFindProcedureTypeByCode(String code) throws DataAccessException {
        return (ProcedureTypeDTO)this.tryFindTypeByCode(code);
    }

    @Override
    public final List<ProcedureTypeDTO> listProcedureTypes() throws DataAccessException {
        return this.listTypes();
    }

    @Override
    protected final ParameterizedRowMapper<ProcedureTypeDTO> getRowMapper() {
        return PROCEDURE_TYPE_ROW_MAPPER;
    }

    @Override
    protected final String getTableName() {
        return "procedure_types";
    }
}

