/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.dto;

import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.lims.server.dto.IRegistratorHolder;
import ch.systemsx.cisd.lims.server.dto.IUntypedValueSetter;
import ch.systemsx.cisd.lims.server.dto.Id;
import ch.systemsx.cisd.lims.server.dto.PersonDTO;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class EntityPropertyValueDTO
implements IRegistratorHolder,
IUntypedValueSetter {
    private final Long registratorID;
    private String valueOrNull;
    private Long vocabularyTermIdOrNull;
    private final long entityPropertyTypeId;
    private final Long propertyTypeId;
    private PersonDTO registrator;
    public static final EntityPropertyValueDTO[] EMPTY_ARRAY = new EntityPropertyValueDTO[0];

    public EntityPropertyValueDTO(Long registratorID, long entityPropertyTypeId) {
        this(registratorID, entityPropertyTypeId, null);
    }

    public EntityPropertyValueDTO(Long registratorID, long entityPropertyTypeId, Long propertyTypeId) {
        this.registratorID = registratorID;
        this.entityPropertyTypeId = entityPropertyTypeId;
        this.propertyTypeId = propertyTypeId;
    }

    public final String tryGetUntypedValue() {
        return this.valueOrNull;
    }

    public final long getEntityPropertyTypeId() {
        return this.entityPropertyTypeId;
    }

    public Long getPropertyTypeId() {
        return this.propertyTypeId;
    }

    public final void setUntypedValue(String valueOrNull, Long vocabularyTermIdOrNull) {
        assert (valueOrNull != null || vocabularyTermIdOrNull == null) : "Value from controlled vocabulary set cannot be null!";
        this.valueOrNull = valueOrNull;
        this.vocabularyTermIdOrNull = vocabularyTermIdOrNull;
    }

    public final PersonDTO getRegistrator() {
        return this.registrator;
    }

    public final Long getRegistratorID() {
        return this.registratorID;
    }

    public final void setRegistrator(PersonDTO registrator) {
        Id.getAndCheckID(registrator, this.registratorID);
        this.registrator = registrator;
    }

    public Long getVocabularyTermId() {
        return this.vocabularyTermIdOrNull;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.entityPropertyTypeId ^ this.entityPropertyTypeId >>> 32);
        result = 31 * result + (this.registrator == null ? 0 : this.registrator.hashCode());
        result = 31 * result + (this.registratorID == null ? 0 : this.registratorID.hashCode());
        result = 31 * result + (this.valueOrNull == null ? 0 : this.valueOrNull.hashCode());
        result = 31 * result + (this.vocabularyTermIdOrNull == null ? 0 : this.vocabularyTermIdOrNull.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EntityPropertyValueDTO other = (EntityPropertyValueDTO)obj;
        if (this.entityPropertyTypeId != other.entityPropertyTypeId) {
            return false;
        }
        if (this.registrator == null ? other.registrator != null : !this.registrator.equals(other.registrator)) {
            return false;
        }
        if (this.registratorID == null ? other.registratorID != null : !this.registratorID.equals(other.registratorID)) {
            return false;
        }
        if (this.valueOrNull == null ? other.valueOrNull != null : !this.valueOrNull.equals(other.valueOrNull)) {
            return false;
        }
        return !(this.vocabularyTermIdOrNull == null ? other.vocabularyTermIdOrNull != null : !this.vocabularyTermIdOrNull.equals(other.vocabularyTermIdOrNull));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }
}

