/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.AbstractStackPanelItem;
import ch.systemsx.cisd.lims.webclient.client.application.ExperimentTab;
import ch.systemsx.cisd.lims.webclient.client.application.ILoadable;
import ch.systemsx.cisd.lims.webclient.client.application.IResultDisplayer;
import ch.systemsx.cisd.lims.webclient.client.application.IStackPanelItem;
import ch.systemsx.cisd.lims.webclient.client.application.MasterPlateTab;
import ch.systemsx.cisd.lims.webclient.client.application.ToolbarPanel;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.utils.Log;
import com.google.gwt.user.client.ui.StackPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Ext;
import com.gwtext.client.widgets.layout.BorderLayout;
import com.gwtext.client.widgets.layout.ContentPanel;
import com.gwtext.client.widgets.layout.LayoutRegion;
import com.gwtext.client.widgets.layout.LayoutRegionConfig;
import java.util.ArrayList;
import java.util.List;

public final class MainPage
extends BorderLayout
implements IResultDisplayer {
    static final ContentPanel BLANK_CONTENT_PANEL = MainPage.createCenterPanel();
    private final ViewContext viewContext;

    public MainPage(ViewContext viewContext) {
        super("100%", "100%", MainPage.createNorthRegion(), null, MainPage.createWestRegion(), null, MainPage.createCenterRegion());
        this.viewContext = viewContext;
        this.add(LayoutRegionConfig.NORTH, this.createToolbarPanel(this));
        this.add(LayoutRegionConfig.WEST, this.createStackPanel());
        this.add(LayoutRegionConfig.CENTER, BLANK_CONTENT_PANEL);
    }

    private final ContentPanel createStackPanel() {
        StackPanel stackPanel = new StackPanel();
        stackPanel.setWidth("100%");
        stackPanel.setStyleName("lims-stack-panel");
        ContentPanel contentPanel = new ContentPanel();
        contentPanel.add((Widget)stackPanel);
        List stackPanelItems = this.createStackPanelItems();
        for (IStackPanelItem page : stackPanelItems) {
            stackPanel.add((Widget)page.getExplorerPanel(this), page.getTitle());
        }
        return contentPanel;
    }

    private final List createStackPanelItems() {
        ArrayList<AbstractStackPanelItem> stackPanelItems = new ArrayList<AbstractStackPanelItem>();
        stackPanelItems.add(new ExperimentTab(this.viewContext));
        stackPanelItems.add(new MasterPlateTab(this.viewContext));
        return stackPanelItems;
    }

    private final ToolbarPanel createToolbarPanel(MainPage mainPage) {
        return new ToolbarPanel(this.viewContext, mainPage){

            protected final void logoutSuccessful() {
                super.logoutSuccessful();
                MainPage.this.viewContext.getPageController().createLoginPage();
            }
        };
    }

    private static final LayoutRegionConfig createWestRegion() {
        LayoutRegionConfig west = new LayoutRegionConfig();
        west.setSplit(true);
        west.setTitlebar(true);
        west.setInitialSize(175);
        west.setMinSize(50);
        west.setMaxSize(400);
        west.setCollapsible(true);
        west.setAnimate(true);
        west.setCollapsed(false);
        west.setAutoScroll(true);
        return west;
    }

    private static final ContentPanel createCenterPanel() {
        ContentPanel centerPanel = new ContentPanel(Ext.generateId());
        VerticalPanel contentPanel = new VerticalPanel();
        contentPanel.setWidth("100%");
        contentPanel.setHeight("100%");
        centerPanel.add((Widget)contentPanel);
        return centerPanel;
    }

    private static final LayoutRegionConfig createCenterRegion() {
        LayoutRegionConfig center = new LayoutRegionConfig();
        center.setTitlebar(false);
        center.setAutoScroll(true);
        return center;
    }

    private static final LayoutRegionConfig createNorthRegion() {
        LayoutRegionConfig north = new LayoutRegionConfig();
        north.setSplit(false);
        north.setInitialSize(30);
        north.setTitlebar(false);
        north.setAutoScroll(false);
        return north;
    }

    public final void displayResult(IStackPanelItem stackPanelItem, Object result) {
        ContentPanel contentPanel;
        Log.log("The user object for stack panel page '" + stackPanelItem.getTitle() + "' is ready to be displayed.");
        LayoutRegion region = this.getRegion(LayoutRegionConfig.CENTER);
        region.removeAll(true);
        Widget contentWidget = stackPanelItem.getContentWidget(result);
        if (contentWidget != null) {
            assert (!(contentWidget instanceof ContentPanel));
            contentPanel = new ContentPanel();
            contentPanel.add(contentWidget);
        } else {
            contentPanel = BLANK_CONTENT_PANEL;
        }
        this.add(contentPanel);
        if (contentWidget instanceof ILoadable) {
            ((ILoadable)contentWidget).load();
        }
    }
}

