/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.ColumnGrid;
import ch.systemsx.cisd.lims.webclient.client.application.ColumnView;
import ch.systemsx.cisd.lims.webclient.client.application.ExperimentContentPanel;
import ch.systemsx.cisd.lims.webclient.client.application.ILoadable;
import ch.systemsx.cisd.lims.webclient.client.application.IMessageResources;
import ch.systemsx.cisd.lims.webclient.client.application.LinkColumnView;
import ch.systemsx.cisd.lims.webclient.client.application.PropertyValueRenderers;
import ch.systemsx.cisd.lims.webclient.client.application.ShowLayoutClickListener;
import ch.systemsx.cisd.lims.webclient.client.application.TextColumnView;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.ui.PropertyGrid;
import ch.systemsx.cisd.lims.webclient.client.application.ui.SimpleTable;
import ch.systemsx.cisd.lims.webclient.client.application.utils.Log;
import ch.systemsx.cisd.lims.webclient.client.application.utils.OrderedMap;
import ch.systemsx.cisd.lims.webclient.client.application.utils.WindowUtils;
import ch.systemsx.cisd.lims.webclient.client.dto.Column;
import ch.systemsx.cisd.lims.webclient.client.dto.Invalidation;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import ch.systemsx.cisd.lims.webclient.client.dto.SimpleEntityProperty;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.ExtElement;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.Store;
import com.gwtext.client.util.Format;
import com.gwtext.client.widgets.PagingToolbar;
import com.gwtext.client.widgets.PagingToolbarConfig;
import com.gwtext.client.widgets.grid.Grid;
import com.gwtext.client.widgets.grid.event.GridCellListener;
import com.gwtext.client.widgets.grid.event.GridCellListenerAdapter;
import java.util.ArrayList;
import java.util.List;

public final class MasterPlateContentPanel
extends VerticalPanel
implements ILoadable {
    private static final boolean USING_SIMPLE_TABLE = false;
    private static final int NUMBER_OF_VISIBLE_ROWS = 20;
    private final Sample sample;
    private final Column[] columns;
    private final List columnsWithLinks;
    private final ViewContext viewContext;
    private Grid sampleGrid;

    public MasterPlateContentPanel(Sample sample, Column[] columns, ViewContext viewContext) {
        assert (sample != null) : "Given sample can not be null.";
        assert (columns != null) : "Given columns can not be null.";
        this.sample = sample;
        this.columns = columns;
        this.viewContext = viewContext;
        this.columnsWithLinks = new ArrayList();
        this.columnsWithLinks.add("USER.GENE_SYMBOL");
        this.setWidth("100%");
        this.setSpacing(5);
        this.add(this.createTitle());
        this.add(this.createGeneralPart());
        this.add(this.createVisualizationPart());
        this.add(this.createLayoutPart());
    }

    private final Widget createGeneralPart() {
        IMessageResources messageResources = this.viewContext.getMessageResources();
        VerticalPanel verticalPanel = MasterPlateContentPanel.createVerticalPanelPart();
        verticalPanel.add(MasterPlateContentPanel.createPartTitle(messageResources.getExperimentPanelGeneralTitle()));
        OrderedMap properties = new OrderedMap(false);
        properties.put(messageResources.getRegistratorLabel(), this.sample.getRegistrator());
        properties.put(messageResources.getRegistrationLabel(), this.sample.getRegistrationDate());
        SimpleEntityProperty[] entityProperties = this.sample.getProperties();
        int i = 0;
        while (i < entityProperties.length) {
            if (entityProperties[i] != null) {
                properties.put(entityProperties[i].getUserLabel(), entityProperties[i].tryGetUntypedValue());
            }
            ++i;
        }
        Invalidation invalidation = this.sample.getInvalidation();
        if (invalidation != null) {
            properties.put(messageResources.getSampleInvalidationDateLabel(), invalidation.getRegistrationDate());
            properties.put(messageResources.getSampleInvalidatorLabel(), invalidation.getRegistrator());
            String reason = invalidation.getReason();
            if (reason == null) {
                reason = "Unknown";
            }
            properties.put(messageResources.getExperimentInvalidationReasonLabel(), reason);
        }
        verticalPanel.add((Widget)this.createPropertyGrid(properties));
        return verticalPanel;
    }

    private final PropertyGrid createPropertyGrid(OrderedMap properties) {
        IMessageResources messageResources = this.viewContext.getMessageResources();
        PropertyGrid propertyGrid = new PropertyGrid(messageResources, properties.size());
        propertyGrid.registerPropertyValueRenderer("ch.systemsx.cisd.lims.webclient.client.dto.Material", new PropertyValueRenderers.MaterialPropertyValueRenderer(messageResources));
        propertyGrid.registerPropertyValueRenderer("ch.systemsx.cisd.lims.webclient.client.dto.Person", new PropertyValueRenderers.PersonPropertyValueRenderer(messageResources));
        propertyGrid.registerPropertyValueRenderer("ch.systemsx.cisd.lims.webclient.client.dto.Project", new PropertyValueRenderers.ProjectPropertyValueRenderer(messageResources));
        propertyGrid.setProperties(properties);
        return propertyGrid;
    }

    private final Widget createLayoutPart() {
        VerticalPanel verticalPanel = MasterPlateContentPanel.createVerticalPanelPart();
        verticalPanel.add(MasterPlateContentPanel.createPartTitle(this.viewContext.getMessageResources().getMasterPlateLayoutTitle()));
        long time = System.currentTimeMillis();
        verticalPanel.add(this.createMasterPlatesGrid());
        Log.logTimeTaken(time, "Create and add master plate");
        return verticalPanel;
    }

    private final Widget createSimpleGrid() {
        ColumnView[] views = new ColumnView[this.columns.length];
        int i = 0;
        while (i < views.length) {
            Column column = this.columns[i];
            ColumnView view = this.columnsWithLinks.contains(column.getUniqueName()) ? new LinkColumnView(column) : new TextColumnView(column);
            views[i] = view;
            ++i;
        }
        return new SimpleTable(400, views);
    }

    private final Widget createMasterPlatesGrid() {
        VerticalPanel verticalPanel = MasterPlateContentPanel.createVerticalPanelPart();
        if (this.columns.length == 0) {
            HTML html = new HTML();
            html.setText(this.viewContext.getMessageResources().getEmpty("well", "master plate"));
            verticalPanel.add((Widget)html);
        } else {
            boolean sortable = this.columns.length == 0 || this.columns[0].getValues().length <= 20;
            this.sampleGrid = new ColumnGrid(this.columns, this.columnsWithLinks, null, sortable);
            this.sampleGrid.addGridCellListener((GridCellListener)new GridCellListenerAdapter(){

                public final void onCellClick(Grid grid, int rowIndex, int colIndex, EventObject e) {
                    String dataIndex = grid.getColumnModel().getDataIndex(colIndex);
                    if (dataIndex.equals("USER.GENE_SYMBOL")) {
                        Record record = grid.getStore().getAt(rowIndex);
                        String geneSymbol = record.getAsString(dataIndex);
                        WindowUtils.openNewDependentWindow(Format.format((String)"http://www.genecards.org/cgi-bin/carddisp.pl?gene={0}", (String)geneSymbol));
                    }
                }
            });
            ExtElement footerPanel = this.sampleGrid.getView().getFooterPanel(true);
            Store store = this.sampleGrid.getStore();
            new PagingToolbar(footerPanel, store, new PagingToolbarConfig(){
                {
                    this.setPageSize(20);
                    this.setDisplayInfo(true);
                    this.setDisplayMsg("Displaying wells {0} - {1} of {2}");
                    this.setEmptyMsg("No wells to display");
                }
            });
            verticalPanel.add((Widget)this.sampleGrid);
        }
        return verticalPanel;
    }

    private static final VerticalPanel createVerticalPanelPart() {
        return ExperimentContentPanel.createVerticalPanelPart();
    }

    private final Widget createVisualizationPart() {
        VerticalPanel verticalPanel = MasterPlateContentPanel.createVerticalPanelPart();
        IMessageResources messageResources = this.viewContext.getMessageResources();
        verticalPanel.add(MasterPlateContentPanel.createPartTitle(messageResources.getVisualizationLabel()));
        HTML sampleLayoutButton = new HTML(String.valueOf(messageResources.getShowMasterPlateLayoutLabel()) + ": " + this.sample.getCode());
        sampleLayoutButton.setStyleName("lims-a");
        ShowLayoutClickListener sampleLayoutClickListener = new ShowLayoutClickListener(this.sample.getCode(), (Widget)sampleLayoutButton, this.viewContext);
        sampleLayoutButton.addClickListener((ClickListener)sampleLayoutClickListener);
        verticalPanel.add((Widget)sampleLayoutButton);
        if (this.sample.getControlLayoutCode() != null) {
            HTML controlLayoutButton = new HTML(String.valueOf(messageResources.getShowControlLayoutLabel()) + ": " + this.sample.getControlLayoutCode());
            controlLayoutButton.setStyleName("lims-a");
            ShowLayoutClickListener controlLayoutClickListener = new ShowLayoutClickListener(this.sample.getControlLayoutCode(), (Widget)controlLayoutButton, this.viewContext);
            controlLayoutButton.addClickListener((ClickListener)controlLayoutClickListener);
            verticalPanel.add((Widget)controlLayoutButton);
        }
        return verticalPanel;
    }

    private static final Widget createPartTitle(String text) {
        HTML html = new HTML(text);
        html.setStyleName("lims-heading");
        return html;
    }

    private final Widget createTitle() {
        HorizontalPanel outerPanel = new HorizontalPanel();
        HorizontalPanel innerPanel = new HorizontalPanel();
        outerPanel.setWidth("100%");
        outerPanel.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
        outerPanel.add((Widget)innerPanel);
        IMessageResources messageResources = this.viewContext.getMessageResources();
        String title = messageResources.getMasterPlatePanelTitle(this.sample.getCode());
        HTML html = new HTML(title);
        html.setStyleName("lims-font-big");
        innerPanel.add((Widget)html);
        if (this.sample.getInvalidation() != null) {
            innerPanel.setSpacing(10);
            HTML invalid = new HTML(messageResources.getInvalidLabel());
            invalid.setStyleName("lims-font-big-red");
            innerPanel.add((Widget)invalid);
        }
        return outerPanel;
    }

    public final void load() {
        if (this.sampleGrid != null) {
            this.sampleGrid.getStore().load(0, 20);
        }
    }
}

