/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.lims.webclient.client.application.AbstractAsyncCallbackWithLoadingMask;
import ch.systemsx.cisd.lims.webclient.client.application.AbstractTreePanel;
import ch.systemsx.cisd.lims.webclient.client.application.SampleNode;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.utils.Log;
import ch.systemsx.cisd.lims.webclient.client.dto.Column;
import ch.systemsx.cisd.lims.webclient.client.dto.Sample;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.Node;
import com.gwtext.client.widgets.tree.TreeNode;
import com.gwtext.client.widgets.tree.event.TreePanelListener;
import com.gwtext.client.widgets.tree.event.TreePanelListenerAdapter;

public class SampleExplorer
extends AbstractTreePanel {
    public SampleExplorer(ViewContext viewContext) {
        super(viewContext);
        this.addTreePanelListener((TreePanelListener)new SampleExplorerTreePanelListener());
        this.setRootNode(this.createRootNode());
        this.render();
        this.loadMasterPlates();
    }

    private final Node createRootNode() {
        TreeNode rootNode = new TreeNode(this.viewContext.getMessageResources().getMasterPlateExplorerTitle());
        return rootNode;
    }

    private final void loadMasterPlates() {
        this.viewContext.getLimService().listSamples("MASTER_PLATE", new SampleAsyncCallback());
    }

    protected void displaySample(Sample sample, Column[] plateWells) {
    }

    private final class MasterPlateAsyncCallback
    extends AbstractAsyncCallbackWithLoadingMask {
        private final Sample sample;
        private final long start;

        MasterPlateAsyncCallback(Sample sample, long start) {
            super(SampleExplorer.this.viewContext);
            this.sample = sample;
            this.start = start;
        }

        protected final void afterSuccess(Object result) {
            Log.logTimeTaken(this.start, "Getting plate wells");
            SampleExplorer.this.displaySample(this.sample, (Column[])result);
        }
    }

    private final class SampleAsyncCallback
    extends AbstractAsyncCallback {
        SampleAsyncCallback() {
            super(SampleExplorer.this.viewContext);
        }

        public final void onSuccess(Object result) {
            Sample[] samples = (Sample[])result;
            int i = 0;
            while (i < samples.length) {
                Sample project = samples[i];
                SampleNode projectNode = new SampleNode(SampleExplorer.this.viewContext.getMessageResources(), project);
                SampleExplorer.this.getRootNode().appendChild((Node)projectNode);
                ++i;
            }
        }
    }

    private final class SampleExplorerTreePanelListener
    extends TreePanelListenerAdapter {
        private SampleExplorerTreePanelListener() {
        }

        public final void onClick(TreeNode node, EventObject e) {
            Log.log("Sample node '" + node.getText() + "' has been clicked.");
            Sample sample = (Sample)node.getUserObject();
            long start = System.currentTimeMillis();
            SampleExplorer.this.viewContext.getLimService().getMasterPlate(sample.getCode(), new MasterPlateAsyncCallback(sample, start));
        }
    }
}

