/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.webclient.client.application;

import ch.systemsx.cisd.lims.webclient.client.application.AbstractTreePanel;
import ch.systemsx.cisd.lims.webclient.client.application.ExperimentContentPanel;
import ch.systemsx.cisd.lims.webclient.client.application.IResultDisplayer;
import ch.systemsx.cisd.lims.webclient.client.application.IStackPanelItem;
import ch.systemsx.cisd.lims.webclient.client.application.ModelBasedGrid;
import ch.systemsx.cisd.lims.webclient.client.application.context.ViewContext;
import ch.systemsx.cisd.lims.webclient.client.application.model.SearchHitDescriptionGridModel;
import ch.systemsx.cisd.lims.webclient.client.dto.SearchHitDescription;
import ch.systemsx.cisd.lims.webclient.client.dto.SearchResult;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

class SearchResultPanel
implements IStackPanelItem {
    private final ViewContext viewContext2;
    private final SearchResult searchResult;
    private final String query;

    public SearchResultPanel(ViewContext viewContext, SearchResult searchResult, String query) {
        this.viewContext2 = viewContext;
        this.searchResult = searchResult;
        this.query = query;
    }

    private Widget createTable(String entityLabel, SearchHitDescription[] hits) {
        VerticalPanel verticalPanel = ExperimentContentPanel.createVerticalPanelPart();
        verticalPanel.setWidth("100%");
        verticalPanel.setSpacing(5);
        verticalPanel.add(ExperimentContentPanel.createPartTitle(String.valueOf(entityLabel) + "s"));
        int len = hits.length;
        if (len == 0) {
            verticalPanel.add((Widget)new HTML("No results."));
        } else {
            SearchHitDescriptionGridModel gridModel = new SearchHitDescriptionGridModel(this.viewContext2.getMessageResources(), entityLabel);
            ModelBasedGrid grid = new ModelBasedGrid(this.viewContext2.getMessageResources(), hits, gridModel, null);
            verticalPanel.add((Widget)grid);
        }
        return verticalPanel;
    }

    public Widget getContentWidget(Object result) {
        int materialsNotShown;
        int samplesNotShown;
        VerticalPanel panel = new VerticalPanel();
        panel.setWidth("100%");
        panel.setSpacing(5);
        panel.add(this.createTitle());
        int experimentsNotShown = this.searchResult.getExperimentsFound() - this.searchResult.getExperiments().length;
        if (experimentsNotShown > 0) {
            panel.add((Widget)new HTML(this.getMoreHitsNote("experiments", experimentsNotShown)));
        }
        if ((samplesNotShown = this.searchResult.getSamplesFound() - this.searchResult.getSamples().length) > 0) {
            panel.add((Widget)new HTML(this.getMoreHitsNote("samples", samplesNotShown)));
        }
        if ((materialsNotShown = this.searchResult.getMaterialsFound() - this.searchResult.getMaterials().length) > 0) {
            panel.add((Widget)new HTML(this.getMoreHitsNote("materials", materialsNotShown)));
        }
        panel.add(this.createTable(this.viewContext2.getMessageResources().getSearchExperimentColumnLabel(), this.searchResult.getExperiments()));
        panel.add(this.createTable(this.viewContext2.getMessageResources().getSearchSampleColumnLabel(), this.searchResult.getSamples()));
        panel.add(this.createTable(this.viewContext2.getMessageResources().getSearchMaterialColumnLabel(), this.searchResult.getMaterials()));
        return panel;
    }

    public AbstractTreePanel getExplorerPanel(IResultDisplayer resultDisplayer) {
        return null;
    }

    public String getTitle() {
        return this.viewContext2.getMessageResources().getSearchPanelTitle(this.query);
    }

    public String getMoreHitsNote(String entityType, int hitsNotShown) {
        return this.viewContext2.getMessageResources().getMoreHits(entityType, hitsNotShown);
    }

    private final Widget createTitle() {
        HorizontalPanel outerPanel = new HorizontalPanel();
        HorizontalPanel innerPanel = new HorizontalPanel();
        outerPanel.setWidth("100%");
        outerPanel.setHorizontalAlignment(HorizontalPanel.ALIGN_CENTER);
        outerPanel.add((Widget)innerPanel);
        String title = this.getTitle();
        HTML html = new HTML(title);
        html.setStyleName("lims-font-big");
        innerPanel.add((Widget)html);
        return outerPanel;
    }
}

