/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.compression.file;

import ch.systemsx.cisd.common.compression.file.CompressionWorker;
import ch.systemsx.cisd.common.compression.file.FailureRecord;
import ch.systemsx.cisd.common.compression.file.ICompressionMethod;
import ch.systemsx.cisd.common.logging.Log4jSimpleLogger;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.common.utilities.ISelfTestable;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compressor {
    private static final Logger machineLog;
    private static final Logger operationLog;
    private static final int NUMBER_OF_WORKERS;

    static {
        LogInitializer.init();
        machineLog = LogFactory.getLogger(LogCategory.MACHINE, Compressor.class);
        operationLog = LogFactory.getLogger(LogCategory.OPERATION, Compressor.class);
        NUMBER_OF_WORKERS = Runtime.getRuntime().availableProcessors();
    }

    private static Queue<File> fillWorkerQueueOrExit(File directory, FileFilter filter) {
        File[] filesToCompressOrNull = FileUtilities.tryListFiles(directory, filter, new Log4jSimpleLogger(machineLog));
        if (filesToCompressOrNull == null) {
            System.err.printf("Path '%s' is not a directory.\n", directory.getPath());
            System.exit(1);
            return null;
        }
        if (filesToCompressOrNull.length == 0) {
            System.out.println("No files to compress.");
            System.exit(0);
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Found %d files to compress.", filesToCompressOrNull.length));
        }
        return new ArrayBlockingQueue<File>(filesToCompressOrNull.length, false, (Collection)Arrays.asList(filesToCompressOrNull));
    }

    private static void startUpWorkerThreads(Queue<File> workerQueue, Collection<FailureRecord> failed, ICompressionMethod compressor) {
        int i = 0;
        while (i < NUMBER_OF_WORKERS) {
            new Thread((Runnable)new CompressionWorker(workerQueue, failed, compressor), "Compressor " + i).start();
            ++i;
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Started up %d worker threads.", NUMBER_OF_WORKERS));
        }
    }

    public static Collection<FailureRecord> start(String directoryName, ICompressionMethod compressionMethod) {
        if (compressionMethod instanceof ISelfTestable) {
            ((ISelfTestable)((Object)compressionMethod)).check();
        }
        Queue<File> workerQueue = Compressor.fillWorkerQueueOrExit(new File(directoryName), compressionMethod);
        Collection<FailureRecord> failed = Collections.synchronizedCollection(new ArrayList());
        Compressor.startUpWorkerThreads(workerQueue, failed, compressionMethod);
        return failed;
    }
}

