/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.systemsx.cisd.common.TimingParameters;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.concurrent.ExecutionResult;
import ch.systemsx.cisd.common.concurrent.ExecutionStatus;
import ch.systemsx.cisd.common.concurrent.IActivitySensor;
import ch.systemsx.cisd.common.concurrent.NamedCallable;
import ch.systemsx.cisd.common.concurrent.NamingThreadPoolExecutor;
import ch.systemsx.cisd.common.exceptions.TimeoutException;
import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.logging.LogLevel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringProxy<T> {
    private static final int NUMBER_OF_CORE_THREADS = 10;
    private static final ExecutorService executor = new NamingThreadPoolExecutor("Monitoring Proxy").corePoolSize(10).daemonize();
    private final DelegatingInvocationHandler<T> delegate;
    private final Map<Class<?>, Object> errorTypeValueMap;
    private final Map<Method, Object> errorMethodValueMap;
    private final Set<Class<? extends Exception>> exceptionClassesSuitableForRetrying;
    private final MonitoringInvocationHandler handler;
    private final T proxy;
    private TimingParameters timingParameters;
    private boolean errorValueOnTimeout;
    private boolean errorValueOnInterrupt;
    private String nameOrNull;
    private ISimpleLogger loggerOrNull;
    private IActivitySensor sensorOrNull;

    private static String describe(Method method) {
        StringBuilder builder = new StringBuilder(100);
        builder.append("Call to method '");
        builder.append(method.getDeclaringClass().getSimpleName());
        builder.append('.');
        builder.append(method.getName());
        builder.append('(');
        boolean addComma = false;
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            if (addComma) {
                builder.append(',');
            }
            builder.append(clazz.getSimpleName());
            addComma = true;
            ++n2;
        }
        builder.append(")'");
        return builder.toString();
    }

    private static Map<Class<?>, Object> createDefaultErrorTypeValueMap() {
        HashMap result = new HashMap();
        result.put(Void.TYPE, Void.TYPE.cast(null));
        result.put(Boolean.TYPE, false);
        result.put(Byte.TYPE, (byte)0);
        result.put(Short.TYPE, (short)0);
        result.put(Integer.TYPE, 0);
        result.put(Long.TYPE, 0L);
        return result;
    }

    private static <T> T cast(Class<T> interfaceClass, Object objectToProxyFor) {
        return (T)objectToProxyFor;
    }

    private MonitoringProxy(Class<T> interfaceClass, T objectToProxyFor) {
        assert (interfaceClass.isInterface());
        this.errorTypeValueMap = MonitoringProxy.createDefaultErrorTypeValueMap();
        this.errorMethodValueMap = new HashMap<Method, Object>();
        this.exceptionClassesSuitableForRetrying = new HashSet<Class<? extends Exception>>();
        this.timingParameters = TimingParameters.getNoTimeoutNoRetriesParameters();
        this.delegate = new DelegatingInvocationHandler(objectToProxyFor);
        this.handler = new MonitoringInvocationHandler();
        this.proxy = this.createProxy(interfaceClass, objectToProxyFor);
    }

    private T createProxy(Class<T> interfaceClass, T objectToProxyFor) {
        Class[] interfaceClasses = new Class[]{interfaceClass};
        Object proxyInstance = Proxy.newProxyInstance(interfaceClass.getClassLoader(), interfaceClasses, (InvocationHandler)this.handler);
        return MonitoringProxy.cast(interfaceClass, proxyInstance);
    }

    public static <T> MonitoringProxy<T> create(Class<T> interfaceClass, T objectToProxyFor) {
        return new MonitoringProxy<T>(interfaceClass, objectToProxyFor);
    }

    public MonitoringProxy<T> timing(TimingParameters newParameters) {
        assert (newParameters != null);
        this.timingParameters = newParameters;
        return this;
    }

    public MonitoringProxy<T> errorValueOnTimeout() {
        this.errorValueOnTimeout = true;
        return this;
    }

    public MonitoringProxy<T> errorValueOnInterrupt() {
        this.errorValueOnInterrupt = true;
        return this;
    }

    public MonitoringProxy<T> name(String newName) {
        this.nameOrNull = newName;
        return this;
    }

    public MonitoringProxy<T> errorLog(ISimpleLogger newLogger) {
        this.loggerOrNull = newLogger;
        return this;
    }

    public <V> MonitoringProxy<T> errorTypeValueMapping(Class<V> clazz, V value) {
        this.errorTypeValueMap.put(clazz, value);
        return this;
    }

    public MonitoringProxy<T> errorMethodValueMapping(Method method, Object value) {
        this.errorMethodValueMap.put(method, value);
        return this;
    }

    public MonitoringProxy<T> exceptionClassSuitableForRetrying(Class<? extends Exception> clazz) {
        this.exceptionClassesSuitableForRetrying.add(clazz);
        return this;
    }

    public MonitoringProxy<T> exceptionClassesSuitableForRetrying(Collection<Class<? extends Exception>> classes) {
        this.exceptionClassesSuitableForRetrying.addAll(classes);
        return this;
    }

    public MonitoringProxy<T> sensor(IActivitySensor sensor) {
        this.sensorOrNull = sensor;
        return this;
    }

    public T get() {
        return this.proxy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DelegatingInvocationHandler<T>
    implements InvocationHandler {
        private final T objectToProxyFor;

        private DelegatingInvocationHandler(T objectToProxyFor) {
            this.objectToProxyFor = objectToProxyFor;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                try {
                    return method.invoke(this.objectToProxyFor, args);
                }
                catch (IllegalAccessException illegalAccessException) {
                    method.setAccessible(true);
                    return method.invoke(this.objectToProxyFor, args);
                }
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MonitoringInvocationHandler
    implements InvocationHandler {
        private MonitoringInvocationHandler() {
        }

        @Override
        public Object invoke(Object myProxy, Method method, Object[] args) throws Throwable {
            ExecutionResult<Object> result = this.retryingExecuteInThread(myProxy, method, args);
            if (result.getStatus() == ExecutionStatus.TIMED_OUT) {
                if (!MonitoringProxy.this.errorValueOnTimeout) {
                    throw new TimeoutException(String.valueOf(MonitoringProxy.describe(method)) + " timed out (timeout=" + MonitoringProxy.this.timingParameters.getTimeoutMillis() + "ms).");
                }
                return this.getErrorValue(method);
            }
            if (result.getStatus() == ExecutionStatus.INTERRUPTED && MonitoringProxy.this.errorValueOnInterrupt) {
                return this.getErrorValue(method);
            }
            return ConcurrencyUtilities.tryDealWithResult(result);
        }

        private ExecutionResult<Object> retryingExecuteInThread(Object myProxy, Method method, Object[] args) {
            int counter = 0;
            ExecutionResult<Object> result = null;
            while ((result = this.executeInThread(myProxy, method, args)).getStatus() != ExecutionStatus.COMPLETE && result.getStatus() != ExecutionStatus.INTERRUPTED && !this.exceptionStatusUnsuitableForRetry(result)) {
                if (counter > 0 && MonitoringProxy.this.timingParameters.getIntervalToWaitAfterFailureMillis() > 0L) {
                    try {
                        Thread.sleep(MonitoringProxy.this.timingParameters.getIntervalToWaitAfterFailureMillis());
                    }
                    catch (InterruptedException interruptedException) {
                        return ExecutionResult.createInterrupted();
                    }
                }
                if (counter++ < MonitoringProxy.this.timingParameters.getMaxRetriesOnFailure()) continue;
            }
            return result;
        }

        private boolean exceptionStatusUnsuitableForRetry(ExecutionResult<Object> result) {
            return result.getStatus() == ExecutionStatus.EXCEPTION && !MonitoringProxy.this.exceptionClassesSuitableForRetrying.contains(result.tryGetException().getClass());
        }

        private ExecutionResult<Object> executeInThread(final Object myProxy, final Method method, final Object[] args) {
            final String callingThreadName = Thread.currentThread().getName();
            Future<Object> future = executor.submit(new NamedCallable<Object>(){

                @Override
                public Object call() throws Exception {
                    try {
                        return MonitoringProxy.this.delegate.invoke(myProxy, method, args);
                    }
                    catch (Throwable th) {
                        if (th instanceof Error) {
                            throw (Error)th;
                        }
                        throw (Exception)th;
                    }
                }

                @Override
                public String getCallableName() {
                    if (MonitoringProxy.this.nameOrNull != null) {
                        return String.valueOf(callingThreadName) + "::" + MonitoringProxy.this.nameOrNull;
                    }
                    return String.valueOf(callingThreadName) + "::" + MonitoringProxy.describe(method);
                }
            });
            ConcurrencyUtilities.ILogSettings logSettingsOrNull = MonitoringProxy.this.loggerOrNull == null ? null : new ConcurrencyUtilities.ILogSettings(){

                public LogLevel getLogLevelForError() {
                    return LogLevel.ERROR;
                }

                public ISimpleLogger getLogger() {
                    return MonitoringProxy.this.loggerOrNull;
                }

                public String getOperationName() {
                    if (MonitoringProxy.this.nameOrNull != null) {
                        return String.valueOf(MonitoringProxy.describe(method)) + "[" + MonitoringProxy.this.nameOrNull + "]";
                    }
                    return MonitoringProxy.describe(method);
                }
            };
            return ConcurrencyUtilities.getResult(future, MonitoringProxy.this.timingParameters.getTimeoutMillis(), true, logSettingsOrNull, MonitoringProxy.this.sensorOrNull);
        }

        private Object getErrorValue(Method method) {
            if (MonitoringProxy.this.errorMethodValueMap.containsKey(method)) {
                return MonitoringProxy.this.errorMethodValueMap.get(method);
            }
            if (MonitoringProxy.this.errorTypeValueMap.containsKey(method.getReturnType())) {
                return MonitoringProxy.this.errorTypeValueMap.get(method.getReturnType());
            }
            return null;
        }
    }
}

