/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.mail;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public final class MailClient
extends Authenticator
implements IMailClient {
    private static final String FILE_PREFIX = "file://";
    public static final String MAIL_SMTP_PASSWORD = "mail.smtp.password";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MailClient.class);
    private final String smtpUsername;
    private final String smtpPassword;
    private final String smtpHost;
    private final String from;

    public MailClient(String from, String smtpHost) {
        this(from, smtpHost, null, null);
    }

    public MailClient(Properties properties) {
        this(properties.getProperty("mail.from"), properties.getProperty("mail.smtp.host"), properties.getProperty("mail.smtp.user"), properties.getProperty(MAIL_SMTP_PASSWORD));
    }

    public MailClient(String from, String smtpHost, String smtpUsername, String smtpPassword) {
        assert (from != null);
        assert (smtpHost != null);
        this.from = from;
        this.smtpHost = smtpHost;
        this.smtpUsername = smtpUsername;
        this.smtpPassword = smtpPassword;
    }

    private final Properties createProperties() {
        Properties properties = null;
        try {
            properties = new Properties(System.getProperties());
        }
        catch (SecurityException securityException) {
            properties = new Properties();
        }
        if (this.smtpUsername != null) {
            properties.put("mail.smtp.user", this.smtpUsername);
        }
        if (this.smtpHost != null) {
            properties.put("mail.smtp.host", this.smtpHost);
        }
        if (this.smtpPassword != null && this.smtpUsername != null) {
            properties.put("mail.smtp.auth", Boolean.TRUE.toString());
        }
        properties.put("mail.debug", operationLog.isDebugEnabled() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        properties.put("mail.transport.protocol", "smtp");
        return properties;
    }

    private final Session createSession() {
        boolean mailSmtpAuth;
        Properties properties = this.createProperties();
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Creating mail session with following properties '" + properties + "'."));
        }
        Session session = Session.getInstance((Properties)properties, (Authenticator)((mailSmtpAuth = Boolean.parseBoolean(properties.getProperty("mail.smtp.auth"))) ? this : null));
        session.setDebug(operationLog.isDebugEnabled());
        return session;
    }

    private static final InternetAddress createInternetAddress(String internetAddress) {
        try {
            return new InternetAddress(internetAddress);
        }
        catch (AddressException e) {
            operationLog.error((Object)("Could not parse address [" + internetAddress + "]."), (Throwable)e);
            return null;
        }
    }

    public final void sendMessage(String subject, String content, String ... recipients) throws EnvironmentFailureException {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("Sending message from '" + this.from + "' to recipients '" + Arrays.asList(recipients) + "'"));
        }
        int len = recipients.length;
        InternetAddress[] internetAddresses = new InternetAddress[len];
        int i = 0;
        while (i < len) {
            internetAddresses[i] = MailClient.createInternetAddress(recipients[i]);
            ++i;
        }
        MimeMessage msg = new MimeMessage(this.createSession());
        try {
            msg.setFrom((Address)MailClient.createInternetAddress(this.from));
            msg.addRecipients(Message.RecipientType.TO, (Address[])internetAddresses);
            msg.setSubject(subject);
            msg.setText(content);
            this.send(msg);
        }
        catch (MessagingException ex) {
            throw new EnvironmentFailureException("Sending e-mail with subject '" + subject + "' to recipients " + Arrays.asList(recipients) + " failed. Reason: " + (Object)((Object)ex), ex);
        }
    }

    private void send(MimeMessage msg) throws MessagingException {
        if (this.smtpHost.startsWith(FILE_PREFIX)) {
            File emailFolder = new File(this.smtpHost.substring(FILE_PREFIX.length()));
            if (emailFolder.exists()) {
                if (!emailFolder.isDirectory()) {
                    throw new EnvironmentFailureException("There exists already a file but not a folder with path '" + emailFolder.getAbsolutePath() + "'.");
                }
            } else if (!emailFolder.mkdirs()) {
                throw new EnvironmentFailureException("Couldn't create email folder '" + emailFolder.getAbsolutePath() + "'.");
            }
            File file = FileUtilities.createNextNumberedFile(new File(emailFolder, "email"), null);
            StringBuilder builder = new StringBuilder();
            builder.append("Subj: ").append(msg.getSubject()).append('\n');
            builder.append("From: ").append(this.renderAddresses(msg.getFrom())).append('\n');
            builder.append("To:   ").append(this.renderAddresses(msg.getAllRecipients())).append('\n');
            builder.append("Content:\n");
            try {
                Object content = msg.getContent();
                builder.append(content);
            }
            catch (IOException ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary(ex);
            }
            FileUtilities.writeToFile(file, builder.toString());
        } else {
            Transport.send((Message)msg);
        }
    }

    private String renderAddresses(Address[] addresses) {
        StringBuilder builder = new StringBuilder();
        if (addresses != null) {
            int i = 0;
            while (i < addresses.length) {
                builder.append(addresses[i]);
                if (i < addresses.length - 1) {
                    builder.append(", ");
                }
                ++i;
            }
        }
        return builder.toString();
    }

    protected final PasswordAuthentication getPasswordAuthentication() {
        return new PasswordAuthentication(this.smtpUsername, this.smtpPassword);
    }
}

