/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.parser.Line;
import ch.systemsx.cisd.common.parser.filter.AlwaysAcceptLineFilter;
import ch.systemsx.cisd.common.parser.filter.ILineFilter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.log4j.Logger;

public final class ParserUtilities {
    private static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, ParserUtilities.class);

    private ParserUtilities() {
    }

    public static final Line getFirstAcceptedLine(File file, ILineFilter lineFilter) {
        assert (file != null && file.exists()) : "Given file must not be null and must exist.";
        ILineFilter filter = lineFilter == null ? AlwaysAcceptLineFilter.INSTANCE : lineFilter;
        LineIterator lineIterator = null;
        try {
            lineIterator = FileUtils.lineIterator((File)file);
            int line = 0;
            while (lineIterator.hasNext()) {
                String nextLine = lineIterator.nextLine();
                if (filter.acceptLine(nextLine, line)) {
                    Line line2 = new Line(line, nextLine);
                    return line2;
                }
                try {
                    ++line;
                    continue;
                }
                catch (IOException ex) {
                    machineLog.error((Object)("An I/O exception has occurred while reading file '" + file + "'."), (Throwable)ex);
                }
                break;
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)lineIterator);
        }
        return null;
    }
}

