/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.process;

import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.process.IProcess;

public final class ProcessRunner {
    public ProcessRunner(IProcess process) {
        ProcessRunner.runProcess(process);
    }

    static final void runProcess(IProcess process) throws StopException {
        int maxRetryOnFailure = process.getMaxRetryOnFailure();
        long millisToSleepOnFailure = process.getMillisToSleepOnFailure();
        assert (millisToSleepOnFailure > -1L);
        int counter = 0;
        do {
            StopException.check();
            process.run();
            if (counter <= 0 || millisToSleepOnFailure <= 0L) continue;
            ConcurrencyUtilities.sleep(millisToSleepOnFailure);
        } while (++counter < maxRetryOnFailure && !process.succeeded());
    }
}

