/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.datasetdownload;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.utilities.Template;
import ch.systemsx.cisd.lims.base.Experiment;
import ch.systemsx.cisd.lims.base.ExternalData;
import ch.systemsx.cisd.lims.base.Group;
import ch.systemsx.cisd.lims.base.Procedure;
import ch.systemsx.cisd.lims.base.Project;
import ch.systemsx.cisd.openbis.datasetdownload.IDirectoryRenderer;
import ch.systemsx.cisd.openbis.datasetdownload.RenderingContext;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

final class HTMLDirectoryRenderer
implements IDirectoryRenderer {
    private static final String DATASET_DESCRIPTION = "${group}/${project}/${experiment}/${sample}/${dataset}";
    private static final String DATASET_DOWNLOAD_SERVICE = "Data Set Download Service";
    private static final String TITLE = "<title> Data Set Download Service: ${group}/${project}/${experiment}/${sample}/${dataset}</title>";
    private static final String CSS = "<style type='text/css'> * { margin: 3px; }html { height: 100%;  }body { height: 100%; font-family: verdana, tahoma, helvetica; font-size: 11px; text-align:left; }h1 { text-align: center; padding: 1em; color: #1E4E8F;}.td_hd { border: 1px solid #FFFFFF; padding 3px; background-color: #DDDDDD; height: 1.5em; }.div_hd { background-color: #1E4E8F; color: white; font-weight: bold; padding: 3px; }table { border-collapse: collapse; padding: 1em; }tr, td { font-family: verdana, tahoma, helvetica; font-size: 11px; }.td_file { font-family: verdana, tahoma, helvetica; font-size: 11px; height: 1.5em }.wrapper { min-height: 100%; height: auto !important; height: 100%; margin: 0em auto -4em; }.footer { height: 4em; text-align: center; }</style>";
    private static final Template ROW_TEMPLATE = new Template("<tr><td class='td_file'><a href='${path}'>${name}</td><td>${size}</td></tr>");
    private static final Template HEADER_TEMPLATE = new Template("<html><head><title> Data Set Download Service: ${group}/${project}/${experiment}/${sample}/${dataset}</title><style type='text/css'> * { margin: 3px; }html { height: 100%;  }body { height: 100%; font-family: verdana, tahoma, helvetica; font-size: 11px; text-align:left; }h1 { text-align: center; padding: 1em; color: #1E4E8F;}.td_hd { border: 1px solid #FFFFFF; padding 3px; background-color: #DDDDDD; height: 1.5em; }.div_hd { background-color: #1E4E8F; color: white; font-weight: bold; padding: 3px; }table { border-collapse: collapse; padding: 1em; }tr, td { font-family: verdana, tahoma, helvetica; font-size: 11px; }.td_file { font-family: verdana, tahoma, helvetica; font-size: 11px; height: 1.5em }.wrapper { min-height: 100%; height: auto !important; height: 100%; margin: 0em auto -4em; }.footer { height: 4em; text-align: center; }</style></head><body><div class='wrapper'><h1>Data Set Download Service</h1><div class='div_hd'>Information about data set</div><table><tr><td class='td_hd'>Group:</td><td>${group}</td></tr><tr><td class='td_hd'>Project:</td><td>${project}</td></tr><tr><td class='td_hd'>Experiment:</td><td>${experiment}</td></tr><tr><td class='td_hd'>Sample:</td><td>${sample}</td></tr><tr><td class='td_hd'>Data Set Code:</td><td>${dataset}</td></tr></table> <div class='div_hd'>Files</div><table> ${folder}");
    private static final Template FOOTER_TEMPLATE = new Template("</table> </div> <div class='footer'>${footer} </div> </body></html>");
    private PrintWriter writer;
    private final String urlPrefix;
    private final String relativePathOrNull;

    HTMLDirectoryRenderer(RenderingContext context) {
        this.relativePathOrNull = context.getRelativePathOrNull();
        String prefix = context.getUrlPrefix();
        this.urlPrefix = prefix.endsWith("/") ? prefix : String.valueOf(prefix) + "/";
    }

    public void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    public void printHeader(ExternalData dataSet) {
        String datasetCode = dataSet.getCode();
        String sampleCode = dataSet.getSampleCode();
        Procedure procedure = dataSet.getProcedure();
        Experiment experiment = procedure.getExperiment();
        String experimentCode = experiment.getCode();
        Project project = experiment.getProject();
        String projectCode = project.getCode();
        Group group = project.getGroup();
        String groupCode = group.getCode();
        Template template = HEADER_TEMPLATE.createFreshCopy();
        template.bind("group", groupCode);
        template.bind("project", projectCode);
        template.bind("experiment", experimentCode);
        template.bind("sample", sampleCode);
        template.bind("dataset", datasetCode);
        if (StringUtils.isNotBlank((String)this.relativePathOrNull)) {
            template.bind("folder", "<tr><td class='td_hd'>Folder:</td><td>" + this.relativePathOrNull + "</td></tr>");
        } else {
            template.bind("folder", "");
        }
        this.writer.println(template.createText());
    }

    public void printLinkToParentDirectory(String relativePath) {
        this.printRow("..", relativePath, "");
    }

    public void printDirectory(String name, String relativePath) {
        this.printRow(name, relativePath, "");
    }

    public void printFile(String name, String relativePath, long size) {
        this.printRow(name, relativePath, HTMLDirectoryRenderer.renderFileSize(size));
    }

    private void printRow(String name, String relativePath, String fileSize) {
        Template template = ROW_TEMPLATE.createFreshCopy();
        template.bind("path", String.valueOf(this.urlPrefix) + this.encodeURL(relativePath));
        template.bind("name", name);
        template.bind("size", fileSize);
        this.writer.println(template.createText());
    }

    private String encodeURL(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private static final String renderFileSize(long size) {
        return FileUtils.byteCountToDisplaySize((long)size);
    }

    public void printFooter() {
        Template template = FOOTER_TEMPLATE.createFreshCopy();
        template.bind("footer", "Copyright &copy; 2008 ETHZ - <a href='http://www.cisd.systemsx.ethz.ch/'>CISD</a>");
        this.writer.println(template.createText());
    }
}

