/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds;

import ch.systemsx.cisd.bds.Format;
import ch.systemsx.cisd.bds.FormattedDataContext;
import ch.systemsx.cisd.bds.IFormatParameters;
import ch.systemsx.cisd.bds.IFormattedData;
import ch.systemsx.cisd.bds.Version;
import ch.systemsx.cisd.bds.exception.DataStructureException;
import ch.systemsx.cisd.bds.storage.IDirectory;

public abstract class AbstractFormattedData
implements IFormattedData {
    protected final IDirectory dataDirectory;
    protected final Format format;
    private final IFormatParameters formatParameters;

    protected AbstractFormattedData(FormattedDataContext context) {
        assert (context != null) : "Unspecified context.";
        this.dataDirectory = context.getDataDirectory();
        this.format = context.getFormat();
        this.formatParameters = context.getFormatParameters();
        this.assertValidFormatAndFormatParameters();
    }

    protected void assertValidFormatAndFormatParameters() {
        String formatCode = this.getFormat().getCode();
        if (!this.format.getCode().equals(formatCode)) {
            throw new DataStructureException(String.format("Format codes do not match: '%s' versus '%s'.", this.format.getCode(), formatCode));
        }
        Version formatVersion = this.getFormat().getVersion();
        if (!this.format.getVersion().isBackwardsCompatibleWith(formatVersion)) {
            throw new DataStructureException(String.format("Version '%s' is not backwards compatible with version '%s'.", this.format.getVersion(), formatVersion));
        }
    }

    public final IFormatParameters getFormatParameters() {
        return this.formatParameters;
    }
}

