/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.common.TimingParameters;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.utilities.FastRecursiveHardLinkMaker;
import ch.systemsx.cisd.common.utilities.IImmutableCopier;

public final class LinkMakerProvider {
    private static final String NO_HARD_LINK_EXECUTABLE = "No hard link executable has been found.";
    private static IImmutableCopier hardLinkMaker;

    private LinkMakerProvider() {
    }

    private static final IImmutableCopier tryCreateHardLinkMaker() {
        IImmutableCopier copier = FastRecursiveHardLinkMaker.tryCreate(TimingParameters.getDefaultParameters());
        if (copier != null) {
            return copier;
        }
        throw new EnvironmentFailureException(NO_HARD_LINK_EXECUTABLE);
    }

    public static final IImmutableCopier getLinkMaker() {
        if (hardLinkMaker == null) {
            hardLinkMaker = LinkMakerProvider.tryCreateHardLinkMaker();
        }
        return hardLinkMaker;
    }
}

