/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.bds.storage.filesystem;

import ch.systemsx.cisd.bds.storage.IDirectory;
import ch.systemsx.cisd.bds.storage.IFile;
import ch.systemsx.cisd.bds.storage.IFileBasedDirectory;
import ch.systemsx.cisd.bds.storage.IFileBasedFile;
import ch.systemsx.cisd.bds.storage.IFileBasedNode;
import ch.systemsx.cisd.bds.storage.ILink;
import ch.systemsx.cisd.bds.storage.INode;
import ch.systemsx.cisd.bds.storage.filesystem.Directory;
import ch.systemsx.cisd.bds.storage.filesystem.File;
import ch.systemsx.cisd.bds.storage.filesystem.Link;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileOperations;

public final class NodeFactory {
    public static INode createNode(java.io.File file) throws EnvironmentFailureException {
        assert (file != null) : "Given node can not be null";
        return NodeFactory.internalCreateNode(file);
    }

    public static final ILink createLinkNode(String name, java.io.File file) {
        assert (file != null) : "Given file can not be null";
        assert (name != null) : "Given name can not be null";
        return new Link(name, NodeFactory.internalCreateNode(file));
    }

    public static final ILink createSymbolicLinkNode(java.io.File file) throws EnvironmentFailureException {
        String canonicalPath;
        String absolutePath = file.getAbsolutePath();
        if (absolutePath.equals(canonicalPath = FileOperations.getMonitoredInstanceForCurrentThread().getCanonicalPath(file))) {
            throw new IllegalArgumentException(String.format("Given file must be a link [path=%s].", absolutePath));
        }
        return new Link(file.getName(), NodeFactory.internalCreateNode(new java.io.File(canonicalPath)));
    }

    public static final IFile createFileNode(java.io.File file) {
        assert (file != null) : "Given file must not be null";
        if (!FileOperations.getMonitoredInstanceForCurrentThread().isFile(file)) {
            throw new IllegalArgumentException("File '" + file.getAbsolutePath() + "' is not a file.");
        }
        return NodeFactory.internalCreateFileNode(file);
    }

    public static final IDirectory createDirectoryNode(java.io.File file) {
        assert (file != null) : "Given file must not be null";
        if (!FileOperations.getMonitoredInstanceForCurrentThread().isDirectory(file)) {
            throw new IllegalArgumentException("File '" + file.getAbsolutePath() + "' is not a directory.");
        }
        return NodeFactory.internalCreateDirectoryNode(file);
    }

    static IFileBasedNode internalCreateNode(java.io.File file) {
        if (FileOperations.getMonitoredInstanceForCurrentThread().isDirectory(file)) {
            return NodeFactory.internalCreateDirectoryNode(file);
        }
        return NodeFactory.internalCreateFileNode(file);
    }

    static IFileBasedFile internalCreateFileNode(java.io.File file) {
        return new File(file);
    }

    static IFileBasedDirectory internalCreateDirectoryNode(java.io.File file) {
        return new Directory(file);
    }

    private NodeFactory() {
    }
}

