/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common;

import ch.systemsx.cisd.common.utilities.PropertyUtils;
import java.util.Properties;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class TimingParameters {
    private static final TimingParameters standardParameters = new TimingParameters(60000L, 11, 10000L);
    private static final TimingParameters defaultParameters = new TimingParameters(standardParameters);
    private static final TimingParameters noTimeoutNoRetriesParameters = new TimingParameters(Long.MAX_VALUE, 0, 0L);
    public static final String TIMEOUT_PROPERTY = "timeout";
    public static final String MAX_RETRY_PROPERTY = "max-retries";
    public static final String FAILURE_INTERVAL = "failure-interval";
    private volatile long timeoutMillis;
    private volatile int maxRetriesOnFailure;
    private volatile long intervalToWaitAfterFailureMillis;

    public static final TimingParameters getStandardParameters() {
        return standardParameters;
    }

    public static final TimingParameters getDefaultParameters() {
        return defaultParameters;
    }

    public static final TimingParameters getNoTimeoutNoRetriesParameters() {
        return noTimeoutNoRetriesParameters;
    }

    public static TimingParameters create(Properties properties) {
        return new TimingParameters(properties);
    }

    public static boolean hasTimingParameters(Properties properties) {
        return properties.containsKey(TIMEOUT_PROPERTY) || properties.containsKey(MAX_RETRY_PROPERTY) || properties.containsKey(FAILURE_INTERVAL);
    }

    public static void setDefault(long timeoutMillis, int maxRetriesOnFailure, long intervalToWaitAfterFailureMillis) {
        TimingParameters.defaultParameters.timeoutMillis = timeoutMillis;
        TimingParameters.defaultParameters.maxRetriesOnFailure = maxRetriesOnFailure;
        TimingParameters.defaultParameters.intervalToWaitAfterFailureMillis = intervalToWaitAfterFailureMillis;
    }

    public static void setDefault(TimingParameters timingParameters) {
        TimingParameters.defaultParameters.timeoutMillis = timingParameters.timeoutMillis;
        TimingParameters.defaultParameters.maxRetriesOnFailure = timingParameters.maxRetriesOnFailure;
        TimingParameters.defaultParameters.intervalToWaitAfterFailureMillis = timingParameters.intervalToWaitAfterFailureMillis;
    }

    public static void setDefault(Properties properties) {
        TimingParameters.defaultParameters.timeoutMillis = TimingParameters.getTimeoutMillis(properties);
        TimingParameters.defaultParameters.maxRetriesOnFailure = TimingParameters.getMaxRetriesOnFailure(properties);
        TimingParameters.defaultParameters.intervalToWaitAfterFailureMillis = TimingParameters.getIntervalToWaitAfterFailureMillis(properties);
    }

    private static long getIntervalToWaitAfterFailureMillis(Properties properties) {
        return (long)PropertyUtils.getInt(properties, FAILURE_INTERVAL, 10) * 1000L;
    }

    private static int getMaxRetriesOnFailure(Properties properties) {
        return PropertyUtils.getInt(properties, MAX_RETRY_PROPERTY, 11);
    }

    private static long getTimeoutMillis(Properties properties) {
        long timeoutSpecified = (long)PropertyUtils.getInt(properties, TIMEOUT_PROPERTY, 60) * 1000L;
        return timeoutSpecified == 0L ? Long.MAX_VALUE : timeoutSpecified;
    }

    public static TimingParameters create(long timeoutMillis, int maxRetriesOnFailure, long intervalToWaitAfterFailureMillis) {
        return new TimingParameters(timeoutMillis, maxRetriesOnFailure, intervalToWaitAfterFailureMillis);
    }

    public static TimingParameters create(long timeoutMillis) {
        return new TimingParameters(timeoutMillis, 11, 10000L);
    }

    public static TimingParameters createNoRetries(long timeoutMillis) {
        return new TimingParameters(timeoutMillis, 0, 0L);
    }

    private TimingParameters(TimingParameters parameters) {
        this.timeoutMillis = parameters.timeoutMillis;
        this.maxRetriesOnFailure = parameters.maxRetriesOnFailure;
        this.intervalToWaitAfterFailureMillis = parameters.intervalToWaitAfterFailureMillis;
    }

    private TimingParameters(long timeoutMillis, int maxRetriesOnFailure, long intervalToWaitAfterFailureMillis) {
        this.timeoutMillis = timeoutMillis;
        this.maxRetriesOnFailure = maxRetriesOnFailure;
        this.intervalToWaitAfterFailureMillis = intervalToWaitAfterFailureMillis;
    }

    private TimingParameters(Properties properties) {
        this.timeoutMillis = TimingParameters.getTimeoutMillis(properties);
        this.maxRetriesOnFailure = TimingParameters.getMaxRetriesOnFailure(properties);
        this.intervalToWaitAfterFailureMillis = TimingParameters.getIntervalToWaitAfterFailureMillis(properties);
    }

    public long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public int getMaxRetriesOnFailure() {
        return this.maxRetriesOnFailure;
    }

    public long getIntervalToWaitAfterFailureMillis() {
        return this.intervalToWaitAfterFailureMillis;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TimingParameters)) {
            return false;
        }
        TimingParameters that = (TimingParameters)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.timeoutMillis, that.timeoutMillis);
        builder.append(this.maxRetriesOnFailure, that.maxRetriesOnFailure);
        builder.append(this.intervalToWaitAfterFailureMillis, that.intervalToWaitAfterFailureMillis);
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.timeoutMillis);
        builder.append(this.maxRetriesOnFailure);
        builder.append(this.intervalToWaitAfterFailureMillis);
        return builder.toHashCode();
    }

    public String toString() {
        return String.format("Timing: timeout: %d s, maximal retries: %d, sleep on failure: %d s", this.timeoutMillis / 1000L, this.maxRetriesOnFailure, this.intervalToWaitAfterFailureMillis / 1000L);
    }
}

