/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.compression.file;

import ch.systemsx.cisd.common.compression.file.FailureRecord;
import ch.systemsx.cisd.common.compression.file.ICompressionMethod;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.StatusFlag;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.Collection;
import java.util.Queue;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompressionWorker
implements Runnable {
    static final int MAX_RETRY_OF_FAILED_COMPRESSIONS = 3;
    static final String COMPRESSING_MSG_TEMPLATE = "Compressing '%s'.";
    static final String EXCEPTION_COMPRESSING_MSG_TEMPLATE = "Exceptional condition when trying to compress '%s'.";
    static final String INTERRPTED_MSG = "Thread has been interrupted - exiting worker.";
    static final String EXITING_MSG = "No more files to compress - exiting worker.";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, CompressionWorker.class);
    private final Queue<File> workerQueue;
    private final Collection<FailureRecord> failures;
    private final ICompressionMethod compressor;

    CompressionWorker(Queue<File> incommingQueue, Collection<FailureRecord> failures, ICompressionMethod compressor) {
        assert (incommingQueue != null);
        assert (failures != null);
        assert (compressor != null);
        this.workerQueue = incommingQueue;
        this.failures = failures;
        this.compressor = compressor;
    }

    @Override
    public void run() {
        while (true) {
            if (Thread.interrupted()) {
                if (operationLog.isInfoEnabled()) {
                    operationLog.info(INTERRPTED_MSG);
                }
                return;
            }
            File fileToCompressOrNull = this.workerQueue.poll();
            if (fileToCompressOrNull == null) {
                operationLog.info(EXITING_MSG);
                return;
            }
            if (operationLog.isDebugEnabled()) {
                operationLog.debug(String.format(COMPRESSING_MSG_TEMPLATE, fileToCompressOrNull));
            }
            Status status = null;
            int count = 0;
            do {
                try {
                    status = this.compressor.compress(fileToCompressOrNull);
                }
                catch (Throwable th) {
                    operationLog.error(String.format(EXCEPTION_COMPRESSING_MSG_TEMPLATE, fileToCompressOrNull), th);
                    this.failures.add(new FailureRecord(fileToCompressOrNull, th));
                    status = null;
                    break;
                }
            } while (StatusFlag.RETRIABLE_ERROR.equals((Object)status.getFlag()) && ++count < 3);
            if (status == null || Status.OK.equals(status)) continue;
            this.failures.add(new FailureRecord(fileToCompressOrNull, status));
        }
    }
}

