/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.exceptions;

import ch.systemsx.cisd.common.exceptions.StopException;
import ch.systemsx.cisd.common.exceptions.TimeoutException;
import ch.systemsx.cisd.common.exceptions.WrappedIOException;
import java.io.IOException;

public class CheckedExceptionTunnel
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public CheckedExceptionTunnel(Exception checkedException) {
        super(checkedException);
        assert (checkedException == null || !(checkedException instanceof RuntimeException));
    }

    public static final RuntimeException wrapIfNecessary(Throwable throwable) throws Error {
        if (throwable instanceof Error) {
            if (throwable instanceof ThreadDeath) {
                return new StopException();
            }
            throw (Error)throwable;
        }
        return CheckedExceptionTunnel.wrapIfNecessary((Exception)throwable);
    }

    public static final RuntimeException wrapIfNecessary(Exception exception) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        if (exception instanceof IOException) {
            return new WrappedIOException((IOException)exception);
        }
        if (exception instanceof InterruptedException) {
            return new StopException((InterruptedException)exception);
        }
        if (exception instanceof java.util.concurrent.TimeoutException) {
            return new TimeoutException((java.util.concurrent.TimeoutException)exception);
        }
        return new CheckedExceptionTunnel(exception);
    }

    public static final IOException unwrapIfNecessary(WrappedIOException exception) {
        assert (exception != null) : "Exception not specified.";
        return (IOException)exception.getCause();
    }

    public static final Exception unwrapIfNecessary(Exception exception) {
        assert (exception != null) : "Exception not specified.";
        if (exception instanceof CheckedExceptionTunnel) {
            return (Exception)exception.getCause();
        }
        return exception;
    }
}

