/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem;

import ch.systemsx.cisd.common.exceptions.WrappedIOException;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import java.io.IOException;

public class FileLinkUtilities {
    private static final boolean operational = FileUtilities.loadNativeLibraryFromResource("jlink");

    private static void throwException(String type, String source, String target, String errorMessage) {
        throw new WrappedIOException(new IOException(String.format("Creating %s link '%s' -> '%s': %s", type, source, target, errorMessage)));
    }

    private static void throwException(String filename, String errorMessage) {
        throw new WrappedIOException(new IOException(String.format("Cannot obtain inode info for file '%s': %s", filename, errorMessage)));
    }

    private static native int hardlink(String var0, String var1);

    private static native int symlink(String var0, String var1);

    private static native int linkinfo(String var0, int[] var1);

    private static native String readlink(String var0, int var1);

    private static native String strerror(int var0);

    public static final boolean isOperational() {
        return operational;
    }

    public static final void createHardLink(String filename, String linkname) throws WrappedIOException {
        int result;
        if (filename == null || linkname == null) {
            FileLinkUtilities.throwException("hard", filename, linkname, "null is not allowed");
        }
        if ((result = FileLinkUtilities.hardlink(filename, linkname)) < 0) {
            FileLinkUtilities.throwException("hard", filename, linkname, FileLinkUtilities.strerror(result));
        }
    }

    public static final void createSymbolicLink(String filename, String linkname) throws WrappedIOException {
        int result;
        if (filename == null || linkname == null) {
            FileLinkUtilities.throwException("symbolic", filename, linkname, "null is not allowed");
        }
        if ((result = FileLinkUtilities.symlink(filename, linkname)) < 0) {
            FileLinkUtilities.throwException("symbolic", filename, linkname, FileLinkUtilities.strerror(result));
        }
    }

    private static int[] getLinkInfoArray(String linkname) throws WrappedIOException {
        int[] inodeInfo;
        int result;
        if (linkname == null) {
            FileLinkUtilities.throwException(linkname, "null is not allowed");
        }
        if ((result = FileLinkUtilities.linkinfo(linkname, inodeInfo = new int[4])) < 0) {
            FileLinkUtilities.throwException(linkname, FileLinkUtilities.strerror(result));
        }
        return inodeInfo;
    }

    public static final int getInode(String filename) throws WrappedIOException {
        return FileLinkUtilities.getLinkInfoArray(filename)[0];
    }

    public static final int getHardLinkCount(String filename) throws WrappedIOException {
        return FileLinkUtilities.getLinkInfoArray(filename)[1];
    }

    public static final boolean isSymbolicLink(String filename) throws WrappedIOException {
        return FileLinkUtilities.getLinkInfoArray(filename)[2] != 0;
    }

    public static final String tryReadSymbolicLink(String linkname) throws WrappedIOException {
        int[] info = FileLinkUtilities.getLinkInfoArray(linkname);
        return info[2] != 0 ? FileLinkUtilities.readlink(linkname, info[3]) : null;
    }

    public static final LinkInfo getLinkInfo(String linkname) throws WrappedIOException {
        int[] info = FileLinkUtilities.getLinkInfoArray(linkname);
        String symbolicLinkOrNull = info[2] != 0 ? FileLinkUtilities.readlink(linkname, info[3]) : null;
        return new LinkInfo(info, symbolicLinkOrNull);
    }

    public static final class LinkInfo {
        private final int inode;
        private final int hardLinkCount;
        private final boolean isSsymbolicLink;
        private final String symbolicLinkOrNull;

        private LinkInfo(int[] info, String symbolicLinkOrNull) {
            this.inode = info[0];
            this.hardLinkCount = info[1];
            this.isSsymbolicLink = info[2] != 0;
            this.symbolicLinkOrNull = symbolicLinkOrNull;
        }

        public final boolean isSymbolicLink() {
            return this.isSsymbolicLink;
        }

        public final String tryGetSymbolicLink() {
            return this.symbolicLinkOrNull;
        }

        public final int getInode() {
            return this.inode;
        }

        public final int getHardLinkCount() {
            return this.hardLinkCount;
        }
    }
}

