/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExtractableData;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class DataSetInformation
implements Serializable {
    private static final long serialVersionUID = 18L;
    private String sampleCode;
    private SimpleEntityProperty[] sampleProperties;
    private String instanceCode;
    private ExperimentIdentifier experimentIdentifier;
    private BaseExperiment experiment;
    private BooleanOrUnknown isCompleteFlag = BooleanOrUnknown.UNKNOWN;
    private ExtractableData extractableData = new ExtractableData();

    public DataSetInformation() {
    }

    public DataSetInformation(String instanceCode, ExperimentIdentifier experimentIdentifier, String sampleCode, ExtractableData extractableData) {
        this.setInstanceCode(instanceCode);
        this.setExperimentIdentifier(experimentIdentifier);
        this.setSampleCode(sampleCode);
        if (extractableData != null) {
            this.setExtractableData(extractableData);
        }
    }

    public final BooleanOrUnknown getIsCompleteFlag() {
        return this.isCompleteFlag;
    }

    public final void setComplete(boolean complete) {
        this.isCompleteFlag = BooleanOrUnknown.resolve(complete);
    }

    public final SimpleEntityProperty[] getSampleProperties() {
        return this.sampleProperties;
    }

    public final void setSampleProperties(SimpleEntityProperty[] sampleProperties) {
        this.sampleProperties = sampleProperties;
    }

    public final String getInstanceCode() {
        return this.instanceCode;
    }

    public final void setInstanceCode(String instanceCode) {
        this.instanceCode = instanceCode;
    }

    public final void setExperimentIdentifier(ExperimentIdentifier experimentIdentifier) {
        this.experimentIdentifier = experimentIdentifier;
    }

    public final ExperimentIdentifier getExperimentIdentifier() {
        return this.experimentIdentifier;
    }

    public BaseExperiment getExperiment() {
        return this.experiment;
    }

    public void setExperiment(BaseExperiment experiment) {
        this.experiment = experiment;
    }

    public final String getSampleCode() {
        return this.sampleCode;
    }

    public final void setSampleCode(String sampleCode) {
        this.sampleCode = sampleCode;
    }

    public final String getDataSetCode() {
        return this.extractableData.getCode();
    }

    public final void setDataSetCode(String dataSetCode) {
        this.extractableData.setCode(dataSetCode);
    }

    public final String getProducerCode() {
        return this.extractableData.getDataProducerCode();
    }

    public final void setProducerCode(String producerCode) {
        this.extractableData.setDataProducerCode(producerCode);
    }

    public final Date getProductionDate() {
        return this.extractableData.getProductionDate();
    }

    public final void setProductionDate(Date productionDate) {
        this.extractableData.setProductionDate(productionDate);
    }

    public final ExtractableData getExtractableData() {
        return this.extractableData;
    }

    public final void setExtractableData(ExtractableData extractableData) {
        this.extractableData = extractableData;
    }

    public final String getParentDataSetCode() {
        return this.extractableData.getParentDataSetCode();
    }

    public final void setParentDataSetCode(String parentDataSetCode) {
        this.extractableData.setParentDataSetCode(parentDataSetCode);
    }

    public final String describe() {
        if (this.experimentIdentifier == null) {
            return String.format("CODE('%s') SAMPLE_CODE('%s')", this.extractableData.getCode(), this.sampleCode);
        }
        return String.format("CODE('%s') SAMPLE_CODE('%s') EXPERIMENT('%s')", this.extractableData.getCode(), this.sampleCode, this.experimentIdentifier.describe());
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }
}

