/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class DataSetNameEntitiesProvider {
    private final char entitySeparatorCharacter;
    private final String[] entities;
    private final String errorMessagePrefix;

    public DataSetNameEntitiesProvider(File dataSetFile, char entitySeparatorCharacter) {
        this(dataSetFile.getName(), entitySeparatorCharacter);
    }

    public DataSetNameEntitiesProvider(String dataSetName, char entitySeparatorCharacter) {
        assert (dataSetName != null) : "Unspecified data set name.";
        this.entitySeparatorCharacter = entitySeparatorCharacter;
        this.entities = StringUtils.split((String)dataSetName, (char)entitySeparatorCharacter);
        this.errorMessagePrefix = "Invalid data set name '" + dataSetName + "'. ";
    }

    public String getEntity(int index) {
        if (index >= this.entities.length) {
            this.throwUserFailureException(index + 1);
        }
        int actualIndex = index;
        if (index < 0 && (actualIndex = this.entities.length + index) < 0) {
            this.throwUserFailureException(-index);
        }
        return this.entities[actualIndex];
    }

    private void throwUserFailureException(int expectedNumberOfEntities) {
        throw new UserFailureException(String.valueOf(this.errorMessagePrefix) + "We need " + expectedNumberOfEntities + " entities, separated by '" + this.entitySeparatorCharacter + "', but got only " + this.entities.length + ".");
    }
}

