/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver;

import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.etlserver.DataSetInformation;
import ch.systemsx.cisd.etlserver.DataStoreStrategyKey;
import ch.systemsx.cisd.etlserver.IDataStoreStrategy;
import ch.systemsx.cisd.etlserver.IdentifiedDataStrategy;
import ch.systemsx.cisd.lims.base.ObservableType;
import java.io.File;
import java.util.regex.Pattern;

final class NamedDataStrategy
implements IDataStoreStrategy {
    private static final Pattern multipleFilesPatterns = Pattern.compile("_\\[([0-9]+)\\]");
    private final DataStoreStrategyKey key;

    static final File createTargetPath(File targetPath) {
        assert (targetPath != null) : "Given target path can not be null.";
        String defaultFileName = String.valueOf(targetPath.getName()) + "_[1]";
        return FileUtilities.createNextNumberedFile(targetPath, multipleFilesPatterns, defaultFileName);
    }

    NamedDataStrategy(DataStoreStrategyKey key) {
        this.key = key;
    }

    static final String getDirectoryName(DataStoreStrategyKey key) {
        return key.name().toLowerCase();
    }

    private final String getDirectoryName() {
        return NamedDataStrategy.getDirectoryName(this.key);
    }

    private static final void assertBaseDirectory(File baseDirectory) {
        assert (baseDirectory != null) : "Missing base directory.";
    }

    public final DataStoreStrategyKey getKey() {
        return this.key;
    }

    public final File getBaseDirectory(File baseDirectory, DataSetInformation dataSetInfo, ObservableType observableType) {
        NamedDataStrategy.assertBaseDirectory(baseDirectory);
        assert (observableType != null) : "Missing observable type.";
        return new File(new File(baseDirectory, this.getDirectoryName()), IdentifiedDataStrategy.createObservableTypeDirectory(observableType));
    }

    public final File getTargetPath(File baseDirectory, File incomingDataSetPath) {
        NamedDataStrategy.assertBaseDirectory(baseDirectory);
        assert (incomingDataSetPath != null) : "Missing incoming data set path";
        return NamedDataStrategy.createTargetPath(new File(baseDirectory, incomingDataSetPath.getName()));
    }
}

