/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineOptionPrinter;
import org.kohsuke.args4j.CmdLineOptions;
import org.kohsuke.args4j.CmdLineParameters;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.FieldSetter;
import org.kohsuke.args4j.HandlerClasses;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.MethodSetter;
import org.kohsuke.args4j.MultiValueFieldSetter;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineParser {
    private final Object bean;
    private final CmdLineOptions options = new CmdLineOptions();
    private final CmdLineOptionPrinter optionPrinter = new CmdLineOptionPrinter(this.options);
    private Setter<String> argumentSetter;

    public CmdLineParser(Object object) {
        this.bean = object;
        Class<?> clazz = object.getClass();
        while (clazz != null) {
            Argument argument;
            Option option;
            AccessibleObject accessibleObject;
            AccessibleObject[] accessibleObjectArray = clazz.getDeclaredMethods();
            int n = accessibleObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                accessibleObject = accessibleObjectArray[n2];
                option = ((Method)accessibleObject).getAnnotation(Option.class);
                if (option != null) {
                    this.options.addOption(new MethodSetter(object, (Method)accessibleObject), option);
                }
                if ((argument = ((Method)accessibleObject).getAnnotation(Argument.class)) != null) {
                    this.addArgument(new MethodSetter<String>(object, (Method)accessibleObject));
                }
                ++n2;
            }
            accessibleObjectArray = clazz.getDeclaredFields();
            n = accessibleObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                accessibleObject = accessibleObjectArray[n2];
                option = ((Field)accessibleObject).getAnnotation(Option.class);
                if (option != null) {
                    this.options.addOption(this.createFieldSetter((Field)accessibleObject), option);
                }
                if ((argument = ((Field)accessibleObject).getAnnotation(Argument.class)) != null) {
                    this.addArgument(this.createFieldSetter((Field)accessibleObject));
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
    }

    private Setter createFieldSetter(Field field) {
        if (List.class.isAssignableFrom(field.getType())) {
            return new MultiValueFieldSetter(this.bean, field);
        }
        return new FieldSetter(this.bean, field);
    }

    private void addArgument(Setter<String> setter) {
        if (this.argumentSetter != null) {
            throw new IllegalAnnotationError("@Argument is used more than once");
        }
        this.argumentSetter = setter;
    }

    public void printHelp(String string, String string2, String string3, ExampleMode exampleMode) {
        this.optionPrinter.printHelp(string, string2, string3, exampleMode);
    }

    public String printExample(ExampleMode exampleMode) {
        return this.optionPrinter.getExampleString(exampleMode);
    }

    public String printExample(ExampleMode exampleMode, ResourceBundle resourceBundle) {
        return this.optionPrinter.getExampleString(exampleMode, resourceBundle);
    }

    public void printUsage(OutputStream outputStream) {
        this.optionPrinter.printUsage(outputStream);
    }

    public void printUsage(Writer writer, ResourceBundle resourceBundle) {
        this.optionPrinter.printUsage(writer, resourceBundle);
    }

    public void parseArgument(String ... stringArray) throws CmdLineException {
        CmdLineParameters cmdLineParameters = new CmdLineParameters(stringArray);
        HashSet<OptionHandler> hashSet = new HashSet<OptionHandler>();
        boolean bl = false;
        block0: while (cmdLineParameters.hasMore()) {
            String string = cmdLineParameters.getOptionName();
            if (!bl && this.isOption(string)) {
                OptionHandler optionHandler;
                bl = this.isEndOfOptionMarker(string);
                if (bl) {
                    cmdLineParameters.proceed(1);
                    continue;
                }
                int n = string.indexOf(61);
                if (n == -1) {
                    int n2;
                    optionHandler = this.options.getHandlerForOption(string);
                    if (optionHandler != null) {
                        n2 = optionHandler.parseArguments(cmdLineParameters);
                        cmdLineParameters.proceed(n2 + 1);
                        hashSet.add(optionHandler);
                        continue;
                    }
                    if (!this.isLongOption(string)) {
                        n2 = string.length();
                        while (--n2 > 0) {
                            String string2 = string.substring(0, n2);
                            optionHandler = this.options.getHandlerForOption(string2);
                            if (optionHandler == null) continue;
                            optionHandler.set(string.substring(n2));
                            cmdLineParameters.proceed(1);
                            hashSet.add(optionHandler);
                            continue block0;
                        }
                    }
                } else {
                    optionHandler = this.options.getHandlerForOption(string.substring(0, n));
                    if (optionHandler != null) {
                        optionHandler.set(string.substring(n + 1));
                        cmdLineParameters.proceed(1);
                        hashSet.add(optionHandler);
                        continue;
                    }
                }
                throw new CmdLineException(Messages.UNDEFINED_OPTION.format(string));
            }
            if (this.argumentSetter == null) {
                throw new CmdLineException(Messages.NO_ARGUMENT_ALLOWED.format(string));
            }
            this.argumentSetter.addValue(string);
            cmdLineParameters.proceed(1);
        }
        this.options.checkRequiredOptionsPresent(hashSet);
    }

    private boolean isOption(String string) {
        return string.startsWith("-");
    }

    private boolean isLongOption(String string) {
        return string.startsWith("--");
    }

    private boolean isEndOfOptionMarker(String string) {
        return "--".equals(string);
    }

    @Deprecated
    public static void registerHandler(Class clazz, Class<? extends OptionHandler> clazz2) {
        HandlerClasses.registerHandler(clazz, clazz2);
    }

    public void setUsageWidth(int n) {
        this.optionPrinter.setTerminalWidth(n);
    }
}

