/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.db;

public final class SQLCommandTokenizer {
    private final String sqlScript;
    private int index = 0;
    private Mode mode = Mode.SCANNING;
    private boolean newLine = true;
    private boolean newWord = false;
    private Character previous = Character.valueOf('\u0000');
    private Character current;

    public SQLCommandTokenizer(String sqlScript) {
        this.sqlScript = sqlScript;
    }

    public final String getNextCommand() {
        StringBuilder builder = new StringBuilder();
        this.mode = Mode.SCANNING;
        this.newWord = false;
        do {
            switch (this.mode) {
                case SCANNING: {
                    this.scan(builder);
                    break;
                }
                case CONSTANT: {
                    this.scanConstant(builder);
                    break;
                }
                case WHITESPACE: {
                    this.scanWhitespaces();
                }
            }
        } while (this.current.charValue() != '\u0000');
        if (this.index >= this.sqlScript.length() && builder.length() == 0) {
            return null;
        }
        return builder.toString();
    }

    private Character next() {
        this.previous = this.current;
        this.current = this.peek();
        if (this.current.charValue() != '\u0000') {
            ++this.index;
        }
        return this.current;
    }

    private Character peek() {
        if (this.index < this.sqlScript.length()) {
            return Character.valueOf(this.sqlScript.charAt(this.index));
        }
        return Character.valueOf('\u0000');
    }

    private void scan(StringBuilder builder) {
        this.next();
        if (this.current.charValue() == '\u0000') {
            return;
        }
        if (this.newLine && this.current.charValue() == '-' && this.peek().charValue() == '-') {
            this.skipLine();
            this.newWord = false;
            this.mode = Mode.SCANNING;
            return;
        }
        if (Character.isWhitespace(this.current.charValue())) {
            if (this.current.charValue() == '\n') {
                this.newLine = true;
                this.newWord = false;
            } else if (!this.newLine) {
                this.newWord = true;
            }
            this.mode = Mode.WHITESPACE;
            return;
        }
        this.newLine = false;
        if (this.current.charValue() == ';') {
            this.newLine = true;
            if (builder.length() > 0) {
                this.current = Character.valueOf('\u0000');
            }
            return;
        }
        if (this.newWord) {
            builder.append(' ');
            this.newWord = false;
        }
        builder.append(Character.toLowerCase(this.current.charValue()));
        if (this.current.charValue() == ',' && this.peek().charValue() == ' ') {
            this.mode = Mode.WHITESPACE;
            return;
        }
        if (this.current.charValue() == '\'') {
            this.mode = Mode.CONSTANT;
            return;
        }
    }

    private void scanConstant(StringBuilder builder) {
        do {
            this.next();
            if (this.current.charValue() == '\u0000') break;
            builder.append(this.current);
        } while (this.current.charValue() != '\'' || this.previous.charValue() == '\\');
        this.mode = Mode.SCANNING;
    }

    private void scanWhitespaces() {
        while (Character.isWhitespace(this.next().charValue())) {
            if (this.current.charValue() != '\n') continue;
            this.newLine = true;
        }
        if (this.current.charValue() != '\u0000') {
            --this.index;
        }
        this.mode = Mode.SCANNING;
    }

    private void skipLine() {
        do {
            this.next();
        } while (this.current.charValue() != '\n' && this.current.charValue() != '\u0000');
        if (this.current.charValue() != '\u0000') {
            --this.index;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        SCANNING,
        CONSTANT,
        WHITESPACE;

    }
}

