/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.Experiment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.Invalidation;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.Procedure;
import ch.systemsx.cisd.lims.base.Project;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;
import ch.systemsx.cisd.lims.client.parameters.AbstractExperimentParameters;
import ch.systemsx.cisd.lims.client.parameters.IOutputTypeParameters;
import ch.systemsx.cisd.lims.client.utilities.PersonDescriptor;
import ch.systemsx.cisd.lims.client.utilities.Utilities;
import org.kohsuke.args4j.Option;

public abstract class AbstractExperimentInfoCommand
extends AbstractCommandWithSessionToken {
    AbstractExperimentInfoCommand(String name) {
        super(name);
    }

    protected final Experiment tryFetchExperimentBasicAndPrintHeader(String sessionToken, ExperimentInfoParameters parameters) {
        Experiment experiment = this.tryFetchExperiment(sessionToken, parameters);
        if (experiment == null) {
            return null;
        }
        AbstractExperimentInfoCommand.printExperimentInformation(experiment, parameters);
        return experiment;
    }

    private Experiment tryFetchExperiment(String sessionToken, ExperimentInfoParameters parameters) {
        Experiment experiment;
        ILIMSService limsService = this.getLIMSService(parameters);
        ExperimentIdentifier experimentIdentifier = AbstractExperimentInfoCommand.createExperimentIdentifier(parameters);
        try {
            experiment = limsService.getExperimentInfoBasic(sessionToken, experimentIdentifier);
            if (!AbstractExperimentInfoCommand.ensureCodeEqual(experimentIdentifier, experiment.getCode())) {
                return null;
            }
        }
        catch (UserFailureException e) {
            System.err.println("Couldn't get information for experiment '" + experimentIdentifier + "'. Reason: " + e.getMessage());
            return null;
        }
        return experiment;
    }

    protected static final boolean ensureCodeEqual(ExperimentIdentifier experimentIdentifier, String fetchedExperimentCode) {
        String code = experimentIdentifier.getExperimentCode();
        if (!code.equalsIgnoreCase(fetchedExperimentCode)) {
            System.err.println(String.format("Violation: got experiment with code '%s', but require code '%s'", fetchedExperimentCode, code));
            return false;
        }
        return true;
    }

    protected static final ExperimentIdentifier createExperimentIdentifier(ExperimentInfoParameters parameters) {
        return new ExperimentIdentifier(parameters.getProjectCode(), parameters.getExperimentCode());
    }

    protected static final void printExperimentInformation(Experiment experiment, ExperimentInfoParameters parameters) {
        assert (experiment != null);
        assert (parameters != null);
        IOutputPrinter printer = AbstractExperimentInfoCommand.createPrinter(parameters, AbstractExperimentInfoCommand.createSimpleLinePrinter(), "<<<Experiment Information for %s '%s'>>>");
        AbstractExperimentInfoCommand.printBasicExperimentInfo(experiment, printer, parameters.isPrettyPrinted());
        AbstractExperimentInfoCommand.printAdditionalProperties(experiment, printer, parameters.isPrettyPrinted());
        if (parameters.isPrettyPrinted()) {
            System.out.println();
        }
    }

    private static void printBasicExperimentInfo(Experiment experiment, IOutputPrinter printer, boolean prettyMode) {
        assert (experiment != null);
        printer.printKeyValuePair(FieldName.EXPERIMENT_CODE.getName(prettyMode), experiment.getCode());
        printer.printKeyValuePair(FieldName.EXPERIMENT_TYPE.getName(prettyMode), experiment.getExperimentType().getCode());
        Person registrator = experiment.getRegistrator();
        PersonDescriptor.printKeyValueRegisterer(printer, registrator, prettyMode);
        printer.printKeyValuePair(FieldName.REGISTRATION_DATE.getName(prettyMode), Utilities.formatDate(experiment.getRegistrationDate()));
        printer.printKeyValuePair(FieldName.STUDY_OBJECT.getName(prettyMode), experiment.getStudyObject().getCode());
        printer.printKeyValuePair(FieldName.STUDY_OBJECT_TYPE.getName(prettyMode), experiment.getStudyObject().getMaterialType().getCode());
        AbstractExperimentInfoCommand.printControlLayouts(experiment.getProcedures(), printer, prettyMode);
        Project project = experiment.getProject();
        printer.printKeyValuePair(FieldName.PROJECT_CODE.getName(prettyMode), project.getCode());
        printer.printKeyValuePair(FieldName.PROJECT_GROUP.getName(prettyMode), project.getGroup().getCode());
        AbstractExperimentInfoCommand.printInvalidationInfo(experiment.getInvalidation(), printer, prettyMode);
    }

    private static final void printControlLayouts(Procedure[] procedures, IOutputPrinter printer, boolean prettyMode) {
        Procedure[] procedureArray = procedures;
        int n = procedures.length;
        int n2 = 0;
        while (n2 < n) {
            Procedure procedure = procedureArray[n2];
            Sample[] samples = procedure.getInputSamples();
            assert (samples.length <= 1);
            if (samples.length > 0) {
                Sample sample = samples[0];
                String procedureCode = procedure.getProcedureType().getCode();
                String label = String.valueOf(FieldName.CONTROL_LAYOUTS_FOR_.getName(prettyMode)) + procedureCode;
                printer.printKeyValuePair(label, sample.getCode());
            }
            ++n2;
        }
    }

    private static void printInvalidationInfo(Invalidation invalidationOrNull, IOutputPrinter printer, boolean prettyMode) {
        if (invalidationOrNull != null) {
            printer.printKeyValuePair(FieldName.INVALIDATION_DATE.getName(prettyMode), Utilities.formatDate(invalidationOrNull.getRegistrationDate()));
            printer.printKeyValuePair(FieldName.INVALIDATION_REASON.getName(prettyMode), invalidationOrNull.getReason());
            PersonDescriptor.printKeyValueInvalidator(printer, invalidationOrNull.getRegistrator(), prettyMode);
        }
    }

    private static void printAdditionalProperties(Experiment experiment, IOutputPrinter printer, boolean prettyMode) {
        if (experiment.getProperties() != null) {
            SimpleEntityProperty[] properties;
            SimpleEntityProperty[] simpleEntityPropertyArray = properties = experiment.getProperties();
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                SimpleEntityProperty property = simpleEntityPropertyArray[n2];
                if (property.getUntypedValue() != null) {
                    String name = prettyMode ? property.getUserLabel() : property.getCode();
                    printer.printKeyValuePair(name, property.getUntypedValue());
                }
                ++n2;
            }
        }
    }

    protected ExperimentInfoParameters createParameters(String[] arguments) {
        return new ExperimentInfoParameters(arguments, this.getName());
    }

    protected final void printFetchingException(ExperimentIdentifier experimentIdentifier, UserFailureException e) {
        System.err.println("Couldn't get information for experiment '" + experimentIdentifier + "'. Reason: " + e.getMessage());
    }

    static class ExperimentInfoParameters
    extends AbstractExperimentParameters
    implements IOutputTypeParameters {
        @Option(name="P", longName="pretty-print", usage="Output in a pretty printed format")
        private Boolean isPrettyPrinted;

        ExperimentInfoParameters(String[] args, String comandName) {
            super(args, comandName, "<project-code> <experiment-code>");
            if (this.getArgs().size() != 2) {
                System.err.println("Exactly one <project-code> and one <experiment-code> needs to be specified.");
                this.printHelp(true);
            }
        }

        public final boolean isPrettyPrinted() {
            return this.isPrettyPrinted == null ? false : this.isPrettyPrinted;
        }
    }
}

