/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IPropertiesSetter;
import ch.systemsx.cisd.lims.base.IEntityPropertiesHolder;
import ch.systemsx.cisd.lims.base.properties.EntityDataType;
import ch.systemsx.cisd.lims.base.properties.EntityProperties;
import ch.systemsx.cisd.lims.base.properties.EntityPropertySchema;
import ch.systemsx.cisd.lims.base.properties.EntityPropertyValue;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractPropertiesSetter<T extends IEntityPropertiesHolder>
implements IPropertiesSetter<T> {
    private static final SimpleDateFormat SECONDS_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final SimpleDateFormat MINUTES_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final SimpleDateFormat DAYS_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final Map<String, String> lowerCaseCodeToCodeMap;
    private final IEntityPropertiesSchema schema;
    private final EntityProperties properties;

    AbstractPropertiesSetter(IEntityPropertiesSchema schema) {
        assert (schema != null) : "Unspecified entity properties schema.";
        this.lowerCaseCodeToCodeMap = new LinkedHashMap<String, String>();
        String[] stringArray = schema.getAllNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            EntityPropertySchema propertySchema = schema.getPropertySchema(name);
            this.lowerCaseCodeToCodeMap.put(propertySchema.getCode().toLowerCase(), name);
            ++n2;
        }
        this.schema = schema;
        this.properties = new EntityProperties(schema);
    }

    protected abstract T createEntityPropertiesHolder();

    protected abstract boolean setSpecificProperty(String var1, String var2);

    protected abstract List<String> getMandatorySpecificColumns(boolean var1);

    protected final List<String> getAllMandatorySpecificColumns() {
        return this.getMandatorySpecificColumns(false);
    }

    protected final List<String> getMissingMandatorySpecificConstraints() {
        return this.getMandatorySpecificColumns(true);
    }

    private final void checkMandatoryConstraint() {
        ArrayList<String> missing = new ArrayList<String>();
        missing.addAll(this.getMissingMandatorySpecificConstraints());
        missing.addAll(this.getMissingMandatoryPropertiesConstraints());
        if (missing.size() > 0) {
            throw new UserFailureException("Missing values for " + ((Object)missing).toString());
        }
    }

    private List<String> getMandatoryPropertiesColumns(boolean onlyMissing) {
        ConditionalList<String> list = new ConditionalList<String>(onlyMissing);
        String[] stringArray = this.schema.getAllNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            EntityPropertySchema propertySchema = this.schema.getPropertySchema(name);
            if (propertySchema.getIsMandatory()) {
                list.add(name, !this.properties.hasProperty(name));
            }
            ++n2;
        }
        return list.toList();
    }

    private final List<String> getAllMandatoryColumns() {
        ArrayList<String> mandatory = new ArrayList<String>();
        mandatory.addAll(this.getAllMandatorySpecificColumns());
        mandatory.addAll(this.getAllMandatoryPropertiesColumns());
        return mandatory;
    }

    private final List<String> getMissingMandatoryPropertiesConstraints() {
        return this.getMandatoryPropertiesColumns(true);
    }

    private final List<String> getAllMandatoryPropertiesColumns() {
        return this.getMandatoryPropertiesColumns(false);
    }

    private static final String tryNormalizeValue(String name, String valueOrNull, IEntityPropertiesSchema schema) {
        if (valueOrNull == null) {
            return valueOrNull;
        }
        EntityDataType dataType = schema.getPropertySchema(name).getDataTypeCode();
        if (dataType.equals(EntityDataType.DATE)) {
            return AbstractPropertiesSetter.normalizeDate(valueOrNull);
        }
        if (dataType.equals(EntityDataType.VOCABULARY)) {
            return valueOrNull.toUpperCase();
        }
        return valueOrNull;
    }

    private static final String normalizeDate(String untypedDate) {
        SimpleDateFormat[] formats;
        String normalizedDate = null;
        SimpleDateFormat[] simpleDateFormatArray = formats = new SimpleDateFormat[]{EntityPropertyValue.CANONICAL_DATE_FORMAT.get(), SECONDS_DATE_FORMAT, MINUTES_DATE_FORMAT, DAYS_DATE_FORMAT};
        int n = formats.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleDateFormat dateFormat = simpleDateFormatArray[n2];
            normalizedDate = AbstractPropertiesSetter.tryNormalizeDate(untypedDate, dateFormat);
            if (normalizedDate != null) {
                return normalizedDate;
            }
            ++n2;
        }
        throw AbstractPropertiesSetter.createIncorrectDateFormatException(untypedDate, formats);
    }

    private static final UserFailureException createIncorrectDateFormatException(String dateCandidate, SimpleDateFormat[] formats) {
        String availFormatsDesc = AbstractPropertiesSetter.createFormatsDescription(formats);
        return UserFailureException.fromTemplate("Date value '%s' has improper format. The proper formats are: %s.", dateCandidate, availFormatsDesc);
    }

    private static final String createFormatsDescription(SimpleDateFormat[] formats) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < formats.length) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(formats[i].toPattern());
            ++i;
        }
        return sb.toString();
    }

    private static final String tryNormalizeDate(String untypedDate, SimpleDateFormat dateFormat) {
        try {
            Date date = dateFormat.parse(untypedDate);
            return EntityPropertyValue.createDate(date).tryGetUntypedValue();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    @Override
    public final T getConstructedObject() {
        this.checkMandatoryConstraint();
        T constructed = this.createEntityPropertiesHolder();
        constructed.setProperties(this.properties.createSimple());
        return constructed;
    }

    @Override
    public final void setProperty(String name, String value) {
        String valueOrNull = StringUtils.isBlank(value) ? null : value;
        String nameInLowerCase = name.toLowerCase();
        boolean successful = this.setSpecificProperty(nameInLowerCase, valueOrNull);
        if (successful) {
            return;
        }
        String propertyName = this.lowerCaseCodeToCodeMap.get(nameInLowerCase);
        if (propertyName == null) {
            throw new UserFailureException("Unknown property code or column name '" + name + "'." + " Mandatory columns are: " + this.getAllMandatoryColumns());
        }
        valueOrNull = AbstractPropertiesSetter.tryNormalizeValue(propertyName, valueOrNull, this.schema);
        if (this.properties.hasProperty(propertyName)) {
            EntityPropertyValue existingPropertyValue = this.properties.getProperty(propertyName);
            if (existingPropertyValue.tryGetUntypedValue() != null) {
                throw new UserFailureException("Property '" + name + "' is specified more than one time.");
            }
            this.properties.setProperty(propertyName, valueOrNull);
        } else {
            this.properties.setProperty(propertyName, valueOrNull);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConditionalList<E> {
        final List<E> elements;
        final boolean careAboutCondition;

        ConditionalList(boolean careAboutConditions) {
            this.careAboutCondition = careAboutConditions;
            this.elements = new ArrayList();
        }

        void add(E element, boolean condition) {
            if (condition || !this.careAboutCondition) {
                this.elements.add(element);
            }
        }

        List<E> toList() {
            return this.elements;
        }
    }
}

