/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.parser.IParserObjectFactory;
import ch.systemsx.cisd.common.parser.IParserObjectFactoryFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyObjectFactory;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.NewSample;
import ch.systemsx.cisd.lims.base.SampleType;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.properties.EntityKind;
import ch.systemsx.cisd.lims.base.properties.EntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.IEntityPropertiesSchema;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityPropertySchema;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.commands.AbstractFileParameters;
import ch.systemsx.cisd.lims.client.commands.BisTabFileLoader;
import ch.systemsx.cisd.lims.client.commands.SamplePropertiesSetter;
import ch.systemsx.cisd.lims.client.commands.factory.PropertiesParserObjectFactory;
import java.io.File;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRegisterPlatesCommand
extends AbstractCommandWithSessionToken {
    private final String nameOfPlateToRegister;
    private final String nameOfPlateToDeriveFrom;
    private final SampleTypeCode sampleTypeCode;

    protected AbstractRegisterPlatesCommand(String commandName, String nameOfPlateToRegister, SampleTypeCode sampleTypeCode, String nameOfPlateToDeriveFrom) {
        super(commandName);
        this.nameOfPlateToRegister = nameOfPlateToRegister;
        this.sampleTypeCode = sampleTypeCode;
        this.nameOfPlateToDeriveFrom = nameOfPlateToDeriveFrom;
    }

    @Override
    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        File file = parameters.getFile();
        System.out.printf("Register %s plates from '" + file.getAbsolutePath() + "'.\n", this.nameOfPlateToRegister);
        List<NewSample> newSamples = this.createTabFileLoader(sessionToken, limsService).load(file);
        this.enrichSample(newSamples, parameters.tryGetControlLayoutCode());
        limsService.registerSamples(sessionToken, newSamples.toArray(new NewSample[newSamples.size()]));
        for (NewSample newSample : newSamples) {
            System.out.printf("  New %s plate '%s' successfully registered.\n", this.nameOfPlateToRegister, this.describePlate(newSample));
        }
        return 0;
    }

    private BisTabFileLoader<NewSample> createTabFileLoader(String sessionToken, ILIMSService limsService) {
        SimpleEntityPropertySchema[] simpleSchema = limsService.listEntityPropertyTypes(sessionToken, EntityKind.SAMPLE, this.sampleTypeCode.getCode());
        final IEntityPropertiesSchema schema = EntityPropertiesSchema.createFromSimple(simpleSchema);
        SampleType sampleType = new SampleType();
        sampleType.setCode(this.sampleTypeCode.getCode());
        final IPropertyObjectFactory<NewSample> factory = SamplePropertiesSetter.createFactory(sampleType, schema, true);
        IParserObjectFactoryFactory<NewSample> factoryFactory = new IParserObjectFactoryFactory<NewSample>(){

            @Override
            public IParserObjectFactory<NewSample> createFactory(IPropertyMapper propertyMapper) throws ParserException {
                return new PropertiesParserObjectFactory<NewSample>(propertyMapper, schema, factory);
            }
        };
        return new BisTabFileLoader<NewSample>(factoryFactory);
    }

    private void enrichSample(List<NewSample> newSamples, String controlLayoutCodeOrNull) {
        for (NewSample newSample : newSamples) {
            newSample.setSampleTypeCode(this.sampleTypeCode.getCode());
            if (controlLayoutCodeOrNull == null || newSample.getControlLayoutCode() != null) continue;
            newSample.setControlLayoutCode(controlLayoutCodeOrNull);
        }
    }

    private final String describePlate(NewSample newSample) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("[%sPlate=", this.nameOfPlateToRegister)).append(newSample.getSampleCriteria());
        builder.append(String.format(",%sPlate=", this.nameOfPlateToDeriveFrom)).append(newSample.getGeneratedFrom());
        if (!StringUtils.isBlank(newSample.getControlLayoutCode())) {
            builder.append(",controlLayout=");
            builder.append(newSample.getControlLayoutCode());
        }
        builder.append("]");
        return builder.toString();
    }

    protected final class Parameters
    extends AbstractFileParameters {
        @Option(name="c", longName="control-layout", metaVar="<control-layout-code>", usage="Control layout code which will be used for all plates whose control layout has not been specified in the plate file")
        private String controlLayout;

        public Parameters(String[] args) {
            this(args, SystemExit.SYSTEM_EXIT);
        }

        Parameters(String[] args, IExitHandler exitHandler) {
            super(args, AbstractRegisterPlatesCommand.this.getName(), String.format("<%s-plate-file>", AbstractRegisterPlatesCommand.this.nameOfPlateToRegister), exitHandler);
            if (this.getArgs().size() < 1) {
                System.err.printf("Exactly one %s plate file must be specified.\n", AbstractRegisterPlatesCommand.this.nameOfPlateToRegister);
                this.printHelp(true);
            } else if (this.getArgs().size() > 1) {
                System.err.printf("Too many parameters.", new Object[0]);
                this.printHelp(true);
            }
        }

        public String tryGetControlLayoutCode() {
            if (StringUtils.isNotBlank(this.controlLayout)) {
                return this.controlLayout;
            }
            return null;
        }
    }
}

