/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ExperimentTypeCode;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.client.commands.IEntityTypeCodeProvider;

public final class EntityTypeUtils {
    private static final String UNKNOWN_SAMPLE_TYPE_FORMAT = "Unknown %s type code '%s'.";
    private static final String UNKNOWN_EXPERIMENT_TYPE_FORMAT = "Unknown experiment type code '%s'.";
    private static final String SAMPLE_COMMAND_REPLACMENT_HINT = "\nUse '%s' command for this sample type.";

    private EntityTypeUtils() {
    }

    public static final SampleTypeCode getSampleTypeCode(IEntityTypeCodeProvider entityTypeProvider) throws UserFailureException {
        String sampleTypeCode = entityTypeProvider.getEntityTypeCode();
        try {
            return SampleTypeCode.getSampleTypeCode(sampleTypeCode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw UserFailureException.fromTemplate(UNKNOWN_SAMPLE_TYPE_FORMAT, "sample", sampleTypeCode);
        }
    }

    public static final void checkScreeningPlate(IEntityTypeCodeProvider entityTypeProvider, String replacementCommandName) throws UserFailureException {
        assert (entityTypeProvider != null);
        assert (replacementCommandName != null);
        SampleTypeCode sampleType = EntityTypeUtils.getSampleTypeCode(entityTypeProvider);
        assert (sampleType != null) : "Is not null reaching this point.";
        if (!sampleType.isScreeningPlate()) {
            throw UserFailureException.fromTemplate("Unknown %s type code '%s'.\nUse '%s' command for this sample type.", "plate", sampleType.getCode(), replacementCommandName);
        }
    }

    public static final void checkNoControlLayoutPlate(IEntityTypeCodeProvider entityTypeProvider, String replacementCommandName) throws UserFailureException {
        assert (entityTypeProvider != null);
        assert (replacementCommandName != null);
        SampleTypeCode sampleType = EntityTypeUtils.getSampleTypeCode(entityTypeProvider);
        assert (sampleType != null) : "Is not null reaching this point.";
        if (sampleType == SampleTypeCode.CONTROL_LAYOUT) {
            throw UserFailureException.fromTemplate("Unknown %s type code '%s'.\nUse '%s' command for this sample type.", "plate", sampleType.getCode(), replacementCommandName);
        }
    }

    public static final ExperimentTypeCode getExperimentTypeCode(IEntityTypeCodeProvider entityTypeCodeProvider) {
        String entityTypeCode = entityTypeCodeProvider.getEntityTypeCode();
        try {
            return ExperimentTypeCode.getExperimentTypeCode(entityTypeCode);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw UserFailureException.fromTemplate(UNKNOWN_EXPERIMENT_TYPE_FORMAT, entityTypeCode);
        }
    }
}

