/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.parameters.AbstractParameters;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import javax.net.ssl.SSLException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Option;

public class GetDatasetsCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "get-data";
    private static final String URL_PATH_SEPARATOR = "/";
    private static GetDatasetsCommand instance;

    private GetDatasetsCommand() {
        super(NAME);
    }

    public static final synchronized GetDatasetsCommand getInstance() {
        if (instance == null) {
            instance = new GetDatasetsCommand();
        }
        return instance;
    }

    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        GetDatasetsCommand.ensureParametersValid(parameters);
        String pathToDownload = GetDatasetsCommand.extractDatasetPath(parameters);
        ILIMSService limsService = this.getLIMSService(parameters);
        String downloadServerURL = limsService.getDownloadServerUrl(sessionToken);
        DatasetDownloader downloader = new DatasetDownloader(downloadServerURL, sessionToken);
        DatasetItemContent content = downloader.tryFetchDatasetItemContent(pathToDownload);
        if (content == null) {
            return 1;
        }
        if (parameters.isDownloadRecursive()) {
            DatasetItem name = GetDatasetsCommand.figureDatasetItemName(pathToDownload);
            File destinationDir = this.getDownloadDestinationDir(parameters);
            GetDatasetsCommand.downloadRecursively(content, pathToDownload, name, destinationDir, downloader);
            System.out.println("Done.");
        } else {
            GetDatasetsCommand.print(content);
        }
        return 0;
    }

    private static void ensureParametersValid(Parameters parameters) {
        if (!parameters.isDownloadRecursive() && parameters.tryGetDownloadDestination() != null) {
            throw new UserFailureException("Download destination should not be specified without the recursive download option!");
        }
    }

    private File getDownloadDestinationDir(Parameters parameters) {
        File destination = parameters.tryGetDownloadDestination();
        if (destination == null) {
            return new File(".");
        }
        if (!destination.isDirectory()) {
            throw new EnvironmentFailureException("Directory expected but not found: " + destination.getAbsolutePath());
        }
        return destination;
    }

    private static void downloadRecursively(DatasetItemContent content, String fullDownloadPath, DatasetItem item, File destinationDirectory, DatasetDownloader downloader) {
        System.out.println("Fetching: " + fullDownloadPath + "\t" + GetDatasetsCommand.getDescriptionOrEmpty(item));
        File savedFile = GetDatasetsCommand.trySaveContent(content, destinationDirectory, item.getName());
        if (savedFile == null) {
            throw new EnvironmentFailureException("Cannot save " + fullDownloadPath + " in " + destinationDirectory.getAbsolutePath());
        }
        if (content.isDirectoryContent()) {
            DatasetItem[] dirItems = content.asDirectoryContent();
            GetDatasetsCommand.downloadDirectoryRecursively(dirItems, fullDownloadPath, savedFile, downloader);
        }
    }

    private static String getDescriptionOrEmpty(DatasetItem item) {
        String desc = item.tryGetDescription();
        return desc != null ? desc : "";
    }

    private static void downloadDirectoryRecursively(DatasetItem[] items, String parentDownloadedPath, File destinationDirectory, DatasetDownloader downloader) {
        DatasetItem[] datasetItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            DatasetItem item = datasetItemArray[n2];
            String fullDownloadPath = String.valueOf(parentDownloadedPath) + URL_PATH_SEPARATOR + item.getName();
            DatasetItemContent itemContent = downloader.tryFetchDatasetItemContent(fullDownloadPath);
            if (itemContent == null) {
                throw new EnvironmentFailureException("Cannot download " + fullDownloadPath);
            }
            GetDatasetsCommand.downloadRecursively(itemContent, fullDownloadPath, item, destinationDirectory, downloader);
            ++n2;
        }
    }

    private static File trySaveContent(DatasetItemContent content, File parentPath, String itemName) {
        File file = new File(parentPath, itemName);
        boolean ok = content.isDirectoryContent() ? (file.isDirectory() ? true : file.mkdir()) : GetDatasetsCommand.saveFileContent(file, content.asFileContent());
        return ok ? file : null;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean saveFileContent(File file, byte[] bytes) {
        if (file.exists()) {
            System.err.println("File cannot be saved, because it already exists: " + file.getAbsolutePath());
            return false;
        }
        output = null;
        try {
            output = new FileOutputStream(file);
            output.write(bytes);
        }
        catch (FileNotFoundException ex) {
            System.err.println("Cannot create a file: " + ex.getMessage());
lbl12:
            // 2 sources

            while (true) {
                IOUtils.closeQuietly((OutputStream)output);
                return false;
            }
        }
        catch (IOException ex) {
            try {
                System.err.println("Cannot write to a file: " + ex.getMessage());
                ** continue;
            }
            catch (Throwable var4_5) {
                IOUtils.closeQuietly(output);
                throw var4_5;
            }
        }
        IOUtils.closeQuietly((OutputStream)output);
        return true;
    }

    private static DatasetItem figureDatasetItemName(String pathOrNull) {
        String path = pathOrNull.replace("\\", URL_PATH_SEPARATOR);
        int lastSlashIx = path.lastIndexOf(URL_PATH_SEPARATOR);
        if (lastSlashIx < 0) {
            lastSlashIx = 0;
        }
        String itemName = path.substring(lastSlashIx);
        return new DatasetItem(itemName, null);
    }

    private static void print(DatasetItemContent content) {
        if (content.isDirectoryContent()) {
            DatasetItem[] items;
            DatasetItem[] datasetItemArray = items = content.asDirectoryContent();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                DatasetItem item = datasetItemArray[n2];
                System.out.println(String.valueOf(item.getName()) + "\t" + GetDatasetsCommand.getDescriptionOrEmpty(item));
                ++n2;
            }
        } else {
            byte[] fileContent = content.asFileContent();
            try {
                System.out.write(fileContent);
            }
            catch (IOException ex) {
                throw new CheckedExceptionTunnel(ex);
            }
        }
    }

    private static String extractDatasetPath(Parameters parameters) {
        String dataSetCode = parameters.getDatasetCode();
        String pathOrNull = parameters.tryGetPath();
        String path = dataSetCode;
        if (pathOrNull != null) {
            path = String.valueOf(path) + URL_PATH_SEPARATOR + pathOrNull;
        }
        return path;
    }

    private static String encodeAsURL(String path) {
        try {
            return URLEncoder.encode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw EnvironmentFailureException.fromTemplate("Cannot encode path '%s' into URL: %s", path, ex.getMessage());
        }
    }

    private static class DatasetDownloader {
        private static final String BINARY_CONTENT_TYPE = "binary";
        private final String downloadServerURL;
        private final HttpClient httpClient;
        private final String sessionToken;
        private boolean isSessionEstablished;

        public DatasetDownloader(String downloadServerURL, String sessionToken) {
            this.downloadServerURL = downloadServerURL;
            this.sessionToken = sessionToken;
            this.isSessionEstablished = false;
            this.httpClient = new HttpClient();
            this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(30000);
        }

        private String constructDatasetQueryURL(String path) {
            String fullURL = String.valueOf(this.downloadServerURL) + GetDatasetsCommand.URL_PATH_SEPARATOR + GetDatasetsCommand.encodeAsURL(path) + "?mode=txt";
            if (!this.isSessionEstablished) {
                fullURL = String.valueOf(fullURL) + "&sessionID=" + this.sessionToken;
            }
            return fullURL;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public DatasetItemContent tryFetchDatasetItemContent(String pathToDownload) throws EnvironmentFailureException {
            String url = this.constructDatasetQueryURL(pathToDownload);
            GetMethod executedMethod = new GetMethod(url);
            try {
                executedMethod.setFollowRedirects(true);
                this.httpClient.executeMethod((HttpMethod)executedMethod);
                if (executedMethod.getStatusCode() != 200) {
                    System.err.println("Method failed: " + executedMethod.getStatusLine());
                    return null;
                }
                DatasetItemContent content = DatasetDownloader.tryParseGetResult((HttpMethod)executedMethod);
                this.isSessionEstablished = content != null;
                DatasetItemContent datasetItemContent = content;
                return datasetItemContent;
            }
            catch (HttpException he) {
                System.err.println("Http error connecting to '" + url + "': " + he.getMessage());
                return null;
            }
            catch (SSLException ex) {
                System.err.println("Problems with establishing SSL connection to '" + url + "': " + ex.getMessage());
                return null;
            }
            catch (IOException iOException) {
                System.err.println("Unable to connect to the download server '" + url + "'.");
                return null;
            }
            finally {
                executedMethod.releaseConnection();
            }
        }

        private static DatasetItemContent tryParseGetResult(HttpMethod executedMethod) throws IOException {
            if (DatasetDownloader.isFileContent(executedMethod)) {
                byte[] responseBytes = executedMethod.getResponseBody();
                if (responseBytes == null) {
                    return null;
                }
                return DatasetItemContent.createFileContent(responseBytes);
            }
            String responseBody = executedMethod.getResponseBodyAsString();
            if (responseBody == null) {
                System.err.println("Error: could not recieve an answer from the server.");
                return null;
            }
            if (DatasetDownloader.hasErrorOccured(responseBody)) {
                System.err.println(responseBody);
                return null;
            }
            DatasetItem[] items = DatasetDownloader.parseDirectoryContentList(responseBody);
            return DatasetItemContent.createDirectoryContent(items);
        }

        private static DatasetItem[] parseDirectoryContentList(String responseBody) {
            String[] lines = responseBody.split("\n");
            ArrayList<DatasetItem> items = new ArrayList<DatasetItem>();
            int i = 1;
            while (i < lines.length) {
                String desc;
                String[] tokens = lines[i].split("\t");
                String item = tokens[0];
                String string = desc = tokens.length > 1 ? tokens[1] : null;
                if (StringUtils.isNotBlank(item)) {
                    items.add(new DatasetItem(item, desc));
                }
                ++i;
            }
            return items.toArray(new DatasetItem[items.size()]);
        }

        private static boolean hasErrorOccured(String responseBody) {
            return responseBody.startsWith("Error");
        }

        private static boolean isFileContent(HttpMethod method) {
            Header responseHeader = method.getResponseHeader("Content-Type");
            return responseHeader != null && responseHeader.getValue().equals(BINARY_CONTENT_TYPE);
        }
    }

    private static class DatasetItem {
        private final String name;
        private final String descriptionOrNull;

        public DatasetItem(String name, String descriptionOrNull) {
            this.name = name;
            this.descriptionOrNull = descriptionOrNull;
        }

        public String getName() {
            return this.name;
        }

        public String tryGetDescription() {
            return this.descriptionOrNull;
        }
    }

    private static class DatasetItemContent {
        private final Object value;
        private final boolean isDirectoryContent;

        private DatasetItemContent(Object value, boolean isDirectoryList) {
            this.value = value;
            this.isDirectoryContent = isDirectoryList;
        }

        public static DatasetItemContent createFileContent(byte[] content) {
            return new DatasetItemContent(content, false);
        }

        public static DatasetItemContent createDirectoryContent(DatasetItem[] items) {
            return new DatasetItemContent(items, true);
        }

        public boolean isDirectoryContent() {
            return this.isDirectoryContent;
        }

        public byte[] asFileContent() {
            return (byte[])this.value;
        }

        public DatasetItem[] asDirectoryContent() {
            return (DatasetItem[])this.value;
        }
    }

    private static final class Parameters
    extends AbstractParameters {
        private static final String GENERIC_ARGS = "<dataset-code> [<path-in-dataset>]";
        @Option(name="r", longName="recursive", usage="Downloads the specified data and saves them to disc. If a directory is being downloaded, content of all subdirectories will be fetched recursively too.")
        private boolean isDownloadRecursive;
        @Option(name="d", longName="directory", metaVar="destination-path", usage="Directory where the data should be saved. Valid only with recursive download option. If not specified, the current directory will be used.")
        private String destinationDirectoryOrNull;

        Parameters(String[] args) {
            super(args, GetDatasetsCommand.NAME, GENERIC_ARGS);
            if (this.getArgs().size() < 1) {
                System.err.println("Not enough arguments.");
                this.printHelp(true);
            } else if (this.getArgs().size() > 2) {
                System.err.println("To many arguments.");
                this.printHelp(true);
            }
        }

        public String getDatasetCode() {
            return this.getArgs().get(0);
        }

        public String tryGetPath() {
            if (this.getArgs().size() > 1) {
                return this.getArgs().get(1);
            }
            return null;
        }

        public File tryGetDownloadDestination() {
            if (this.destinationDirectoryOrNull == null) {
                return null;
            }
            return new File(this.destinationDirectoryOrNull);
        }

        public boolean isDownloadRecursive() {
            return this.isDownloadRecursive;
        }
    }
}

