/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.IExitHandler;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ExperimentFileAttachment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.parameters.AbstractExperimentParameters;
import java.io.File;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.kohsuke.args4j.Option;

public class GetExperimentAttachmentCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "get-experiment-attachment";
    private static GetExperimentAttachmentCommand instance;

    private GetExperimentAttachmentCommand() {
        super(NAME);
    }

    public static final synchronized GetExperimentAttachmentCommand getInstance() {
        if (instance == null) {
            instance = new GetExperimentAttachmentCommand();
        }
        return instance;
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier(parameters.getProjectCode(), parameters.getExperimentCode());
        File propertyFile = new File(parameters.getPropertyPathname());
        int version = parameters.getVersion();
        if (propertyFile.exists()) {
            System.err.println("Path '" + propertyFile.getAbsolutePath() + "' already exists, won't overwrite.");
            return 1;
        }
        ILIMSService limsService = this.getLIMSService(parameters);
        ExperimentFileAttachment property = limsService.getExperimentFileProperty(sessionToken, experimentIdentifier, propertyFile.getName(), version);
        GetExperimentAttachmentCommand.writePropertyToFile(propertyFile, property);
        System.out.println("Successfully retrieved attachment '" + propertyFile.getAbsolutePath() + "' (version: " + property.getFileProperty().getVersion() + ") from experiment '" + experimentIdentifier + "'.");
        return 0;
    }

    private static void writePropertyToFile(File propertyFile, ExperimentFileAttachment property) {
        try {
            byte[] propertyContent = Base64.decodeBase64((byte[])property.getValue().getBytes("ASCII"));
            FileUtils.writeByteArrayToFile((File)propertyFile, (byte[])propertyContent);
        }
        catch (Exception ex) {
            System.err.println("Could not write file '" + propertyFile.getAbsolutePath() + "' (" + ex.getMessage() + ").");
        }
    }

    private static final class Parameters
    extends AbstractExperimentParameters {
        @Option(name="v", longName="attachmentVersion", usage="version of the experiment attachment to be retrieved")
        private int version;

        public Parameters(String[] args) {
            this(args, SystemExit.SYSTEM_EXIT);
        }

        Parameters(String[] args, IExitHandler exitHandler) {
            super(args, GetExperimentAttachmentCommand.NAME, "<project-code> <experiment-code> <file-name>", exitHandler);
            if (this.getArgs().size() != 3) {
                System.err.println("There needs to be exactly one <project-code>, one <experiment-code> and one <file-name>.");
                this.printHelp(true);
            }
        }

        final String getPropertyPathname() {
            return this.getArgs().get(2);
        }

        public int getVersion() {
            return this.version;
        }
    }
}

