/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.model.ContactTableModel;
import ch.systemsx.cisd.lims.client.parameters.OutputTypeParameters;
import java.util.Arrays;

public final class ListContactsCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "list-contacts";
    private static ListContactsCommand instance;

    private ListContactsCommand() {
        super(NAME);
    }

    public final int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        OutputTypeParameters parameters = new OutputTypeParameters(arguments, NAME);
        ILIMSService limsService = this.getLIMSService(parameters);
        Person[] contacts = limsService.listContacts(sessionToken);
        int numberOfPersons = contacts.length;
        if (numberOfPersons == 0 && parameters.isPrettyPrinted()) {
            System.out.println("No contacts have been found in the database.");
            return 0;
        }
        this.sortById(contacts);
        ContactTableModel model = new ContactTableModel(contacts, null, parameters.isPrettyPrinted());
        this.printTable(model, parameters);
        return 0;
    }

    private void sortById(Person[] persons) {
        Arrays.sort(persons);
    }

    public static final synchronized ListContactsCommand getInstance() {
        if (instance == null) {
            instance = new ListContactsCommand();
        }
        return instance;
    }
}

