/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.Experiment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExperimentPlatesFilter;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.client.commands.AbstractExperimentInfoCommand;
import ch.systemsx.cisd.lims.client.model.ExperimentDatasetTableModel;
import org.kohsuke.args4j.Option;

public class ListExperimentDatasetsCommand
extends AbstractExperimentInfoCommand {
    private static final String NAME = "list-experiment-datasets";
    private static ListExperimentDatasetsCommand instance;

    private ListExperimentDatasetsCommand() {
        super(NAME);
    }

    public static final synchronized ListExperimentDatasetsCommand getInstance() {
        if (instance == null) {
            instance = new ListExperimentDatasetsCommand();
        }
        return instance;
    }

    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        ExperimentDatasetParameters parameters = this.createParameters(arguments);
        Experiment experiment = this.tryFetchExperimentAndPrintHeader(sessionToken, parameters);
        if (experiment == null) {
            return 1;
        }
        ExperimentDatasetTableModel tableModel = new ExperimentDatasetTableModel(experiment.getProcedures(), parameters.isPrettyPrinted());
        this.printTable(tableModel, parameters);
        return 0;
    }

    private Experiment tryFetchExperimentAndPrintHeader(String sessionToken, ExperimentDatasetParameters parameters) {
        Experiment experiment = this.tryFetchExperiment(sessionToken, parameters);
        if (experiment == null) {
            return null;
        }
        AbstractExperimentInfoCommand.printExperimentInformation(experiment, parameters);
        return experiment;
    }

    private Experiment tryFetchExperiment(String sessionToken, ExperimentDatasetParameters parameters) {
        Experiment experiment;
        ILIMSService limsService = this.getLIMSService(parameters);
        ExperimentIdentifier experimentIdentifier = AbstractExperimentInfoCommand.createExperimentIdentifier(parameters);
        try {
            ExperimentPlatesFilter filter = new ExperimentPlatesFilter(parameters.getHideInvalidated());
            experiment = limsService.getExperimentInfoWithDatasets(sessionToken, experimentIdentifier, filter);
            if (!AbstractExperimentInfoCommand.ensureCodeEqual(experimentIdentifier, experiment.getCode())) {
                return null;
            }
        }
        catch (UserFailureException e) {
            super.printFetchingException(experimentIdentifier, e);
            return null;
        }
        return experiment;
    }

    protected ExperimentDatasetParameters createParameters(String[] arguments) {
        return new ExperimentDatasetParameters(arguments);
    }

    static class ExperimentDatasetParameters
    extends AbstractExperimentInfoCommand.ExperimentInfoParameters {
        @Option(name="a", longName="show-also-invalid", usage="Show also invalid plates related to experiment.")
        private Boolean showInvalidatedParameter;

        ExperimentDatasetParameters(String[] args) {
            super(args, ListExperimentDatasetsCommand.NAME);
        }

        final boolean getHideInvalidated() {
            return this.showInvalidatedParameter == null;
        }
    }
}

