/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.Experiment;
import ch.systemsx.cisd.lims.base.ExperimentIdentifier;
import ch.systemsx.cisd.lims.base.ExperimentPlatesFilter;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.Procedure;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.client.commands.AbstractExperimentInfoCommand;
import ch.systemsx.cisd.lims.client.model.ExperimentSamplesTableModel;
import java.util.ArrayList;
import org.kohsuke.args4j.Option;

public class ListExperimentSamplesCommand
extends AbstractExperimentInfoCommand {
    private static final String NAME = "list-experiment-samples";
    private static ListExperimentSamplesCommand instance;

    private ListExperimentSamplesCommand() {
        super(NAME);
    }

    public static final synchronized ListExperimentSamplesCommand getInstance() {
        if (instance == null) {
            instance = new ListExperimentSamplesCommand();
        }
        return instance;
    }

    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments);
        Experiment experiment = this.tryFetchExperimentAndPrintHeader(sessionToken, parameters);
        if (experiment == null) {
            return 1;
        }
        Sample[] samples = ListExperimentSamplesCommand.extractSamples(experiment);
        ExperimentSamplesTableModel tableModel = new ExperimentSamplesTableModel(samples, "Experiment samples", parameters.isPrettyPrinted());
        this.printTable(tableModel, parameters);
        return 0;
    }

    private Experiment tryFetchExperimentAndPrintHeader(String sessionToken, Parameters parameters) {
        Experiment experiment = this.tryFetchExperiment(sessionToken, parameters);
        if (experiment == null) {
            return null;
        }
        AbstractExperimentInfoCommand.printExperimentInformation(experiment, parameters);
        return experiment;
    }

    private Experiment tryFetchExperiment(String sessionToken, Parameters parameters) {
        Experiment experiment;
        ILIMSService limsService = this.getLIMSService(parameters);
        ExperimentIdentifier experimentIdentifier = AbstractExperimentInfoCommand.createExperimentIdentifier(parameters);
        try {
            ExperimentPlatesFilter filter = new ExperimentPlatesFilter(parameters.getHideInvalidated());
            experiment = limsService.getExperimentInfoWithPlates(sessionToken, experimentIdentifier, filter);
            if (!AbstractExperimentInfoCommand.ensureCodeEqual(experimentIdentifier, experiment.getCode())) {
                return null;
            }
        }
        catch (UserFailureException e) {
            super.printFetchingException(experimentIdentifier, e);
            return null;
        }
        return experiment;
    }

    private static Sample[] extractSamples(Experiment experiment) {
        Procedure[] procedures;
        ArrayList<Sample> samples = new ArrayList<Sample>();
        Procedure[] procedureArray = procedures = experiment.getProcedures();
        int n = procedures.length;
        int n2 = 0;
        while (n2 < n) {
            Sample[] procSamples;
            Procedure procedure = procedureArray[n2];
            Sample[] sampleArray = procSamples = procedure.getResultSamples();
            int n3 = procSamples.length;
            int n4 = 0;
            while (n4 < n3) {
                Sample procSample = sampleArray[n4];
                procSample.setProcedure(procedure);
                samples.add(procSample);
                ++n4;
            }
            ++n2;
        }
        return samples.toArray(new Sample[0]);
    }

    private static final class Parameters
    extends AbstractExperimentInfoCommand.ExperimentInfoParameters {
        @Option(name="a", longName="show-also-invalid", usage="Show also invalid samples related to experiment.")
        private Boolean showInvalidatedParameter;

        public Parameters(String[] args) {
            super(args, ListExperimentSamplesCommand.NAME);
        }

        protected boolean getHideInvalidated() {
            return this.showInvalidatedParameter == null;
        }
    }
}

