/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.base.SampleFilter;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.client.commands.EntityTypeUtils;
import ch.systemsx.cisd.lims.client.commands.IEntityTypeCodeProvider;
import ch.systemsx.cisd.lims.client.commands.ListControlLayoutsCommand;
import ch.systemsx.cisd.lims.client.commands.ListSamplesCommand;
import ch.systemsx.cisd.lims.client.model.GenericSampleBasicTableModel;
import ch.systemsx.cisd.lims.client.model.PlateSampleBasicTableModel;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Option;

public class ListPlatesCommand
extends ListSamplesCommand {
    private static final String NAME = "list-plates";
    private static ListPlatesCommand instance;

    private ListPlatesCommand() {
        this(NAME);
    }

    ListPlatesCommand(String name) {
        super(name);
    }

    public static synchronized ListPlatesCommand getInstance() {
        if (instance == null) {
            instance = new ListPlatesCommand();
        }
        return instance;
    }

    SampleTypeCode getSampleTypeCode(IEntityTypeCodeProvider parameters) {
        EntityTypeUtils.checkScreeningPlate(parameters, ListSamplesCommand.getInstance().getName());
        EntityTypeUtils.checkNoControlLayoutPlate(parameters, ListControlLayoutsCommand.getInstance().getName());
        return super.getSampleTypeCode(parameters);
    }

    protected GenericSampleBasicTableModel createGenericTableModel(Sample[] samples, String header, boolean prettyMode) {
        return new PlateSampleBasicTableModel(samples, header, prettyMode);
    }

    ListSamplesCommand.ListSamplesParameters createParameters(String[] arguments) {
        return new Parameters(arguments);
    }

    public static synchronized /* bridge */ /* synthetic */ ListSamplesCommand getInstance() {
        return ListPlatesCommand.getInstance();
    }

    private static final class Parameters
    extends ListSamplesCommand.ListSamplesParameters {
        @Option(name="n", longName="no-experiment", usage="List only plates not registered to an experiment")
        private Boolean notRegisteredToExperiment;
        @Option(name="a", longName="show-also-invalid", usage="Returned results will contain also invalid plates")
        private Boolean showInvalidated;
        private static final String SAMPLE_TYPE_CODE_GENERIC_ARG = "<plate-type-code> [<plate-code pattern(s)>]";

        Parameters(String[] args) {
            super(args, ListPlatesCommand.NAME, SAMPLE_TYPE_CODE_GENERIC_ARG);
            if (this.getArgs().size() < 1) {
                System.err.println("At least the <plate-type-code> [<plate-code pattern(s)>] needs to be specified.");
                this.printHelp(true);
            }
        }

        final boolean getHideInvalidated() {
            return this.showInvalidated == null;
        }

        final boolean isNotRegisteredToExperiment() {
            return this.notRegisteredToExperiment != null && this.notRegisteredToExperiment != false;
        }

        public final String getEntityTypeCode() {
            return StringUtils.upperCase(this.getArgs().get(0));
        }

        public final SampleFilter getSampleFilter() {
            return new SampleFilter(super.getSampleFilter(), this.isNotRegisteredToExperiment(), this.getHideInvalidated());
        }
    }
}

