/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.utilities.FileUtilities;
import ch.systemsx.cisd.common.utilities.SystemExit;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.NewSampleComponent;
import ch.systemsx.cisd.lims.base.SampleTypeCode;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.client.commands.AbstractPropertiesFileParameters;
import ch.systemsx.cisd.lims.client.commands.AbstractRegisterTopPlateCommand;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Option;

public final class RegisterMasterPlateCommand
extends AbstractRegisterTopPlateCommand {
    static final String REGISTER_SUCCESSFUL_FORMAT = "  Master plate '%s' successfully registered.";
    static final String NOT_ENOUGH_ARGUMENTS = "Wrong parameters. At least file path and material batch code must be specified.";
    private static final String NAME = "register-master-plate";
    private static RegisterMasterPlateCommand instance;

    private RegisterMasterPlateCommand() {
        super(NAME, SampleTypeCode.MASTER_PLATE);
    }

    public static final synchronized RegisterMasterPlateCommand getInstance() {
        if (instance == null) {
            instance = new RegisterMasterPlateCommand();
        }
        return instance;
    }

    public int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(arguments, NAME);
        ILIMSService limsService = this.getLIMSService(parameters);
        File fileOrNull = parameters.tryGetFile();
        String code = RegisterMasterPlateCommand.getPlateName(parameters);
        NewSampleComponent[] sampleComponents = this.loadSampleComponentsFromTabFile(fileOrNull);
        SimpleEntityProperty[] propertyValues = this.getPropertyValues(sessionToken, limsService, parameters);
        this.register(limsService, sessionToken, code, propertyValues, sampleComponents, parameters);
        System.out.println(String.format(REGISTER_SUCCESSFUL_FORMAT, code));
        return 0;
    }

    private static String getPlateName(Parameters parameters) {
        File file = parameters.tryGetFile();
        if (file != null) {
            String canonical = FileUtilities.getCanonicalPath(file);
            System.out.println(String.format("Registering master plate, loading data from '%s'.", canonical));
            return RegisterMasterPlateCommand.getSampleCode(canonical);
        }
        String emptyPlateName = parameters.tryGetEmptyPlateName();
        assert (emptyPlateName != null) : "plate name specification missing";
        System.out.println(String.format("Registering empty master plate '%s'.", emptyPlateName));
        return emptyPlateName;
    }

    private final void register(ILIMSService limsService, String sessionToken, String sampleCode, SimpleEntityProperty[] propertyValues, NewSampleComponent[] components, Parameters parameters) {
        limsService.registerMasterPlate(sessionToken, sampleCode, propertyValues, components, parameters.getMaterialBatchCode(), parameters.tryGetControlLayoutCode());
    }

    private static final class Parameters
    extends AbstractPropertiesFileParameters {
        @Option(name="c", longName="control-layout", metaVar="<control-layout-code>", usage="Code of the control layout which is associated with the master plate to be registered")
        private String controlLayout;
        @Option(longName="empty", metaVar="<empty-plate-name>", usage="Name of the master plate which should be created as empty. When this option is given, master plate file should not be specified.")
        private String emptyPlateName;

        public Parameters(String[] args, String commandName) {
            super(args, commandName, "<master-plate-file> <material-batch-code>", SystemExit.SYSTEM_EXIT);
            int argsSize = this.getArgs().size();
            if (argsSize == 0 || argsSize == 1 && !this.isEmptyPlate()) {
                System.err.println(RegisterMasterPlateCommand.NOT_ENOUGH_ARGUMENTS);
                this.printHelp(true);
            } else if (argsSize > 2) {
                System.err.println("Too many parameters.");
                this.printHelp(true);
            }
            if (argsSize == 2 && this.isEmptyPlate()) {
                System.err.println("Requesting creation of the empty plate and specifying its content in the file at the same time is not allowed.");
                this.printHelp(true);
            }
        }

        final File tryGetFile() {
            if (this.isEmptyPlate()) {
                return null;
            }
            return super.getFile();
        }

        final String getMaterialBatchCode() {
            int materialBatchIndex = 1;
            if (this.isEmptyPlate()) {
                --materialBatchIndex;
            }
            return this.getArgs().get(materialBatchIndex);
        }

        private final String tryGetEmptyPlateName() {
            return StringUtils.isBlank(this.emptyPlateName) ? null : this.emptyPlateName;
        }

        private final boolean isEmptyPlate() {
            return this.tryGetEmptyPlateName() != null;
        }

        final String tryGetControlLayoutCode() {
            if (StringUtils.isNotBlank(this.controlLayout)) {
                return this.controlLayout;
            }
            return null;
        }
    }
}

