/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.commands;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.base.ILIMSService;
import ch.systemsx.cisd.lims.base.properties.EntityDataType;
import ch.systemsx.cisd.lims.base.properties.SimpleEntityProperty;
import ch.systemsx.cisd.lims.client.commands.AbstractCommandWithSessionToken;
import ch.systemsx.cisd.lims.client.parameters.AbstractParameters;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public final class SetMaterialPropertyCommand
extends AbstractCommandWithSessionToken {
    private static final String NAME = "set-material-property";
    private static SetMaterialPropertyCommand instance;

    private SetMaterialPropertyCommand() {
        super(NAME);
    }

    public static final synchronized SetMaterialPropertyCommand getInstance() {
        if (instance == null) {
            instance = new SetMaterialPropertyCommand();
        }
        return instance;
    }

    protected int execute(String sessionToken, String[] arguments) throws UserFailureException, EnvironmentFailureException {
        Parameters parameters = new Parameters(this.getName(), arguments);
        ILIMSService limsService = this.getLIMSService(parameters);
        SimpleEntityProperty property = new SimpleEntityProperty(parameters.getPropertyTypeCode(), null, EntityDataType.STRING, (Serializable)((Object)parameters.getPropertyValue()));
        limsService.updateMaterialProperty(sessionToken, parameters.getMaterialTypeCode(), parameters.getMaterialCode(), property);
        System.out.printf("Successfully set property %s='%s' for material '%s' (%s)\n", parameters.getPropertyTypeCode(), parameters.getPropertyValue(), parameters.getMaterialCode(), parameters.getMaterialTypeCode());
        return 0;
    }

    private final class Parameters
    extends AbstractParameters {
        private String propertyTypeCode;
        private String propertyValue;

        Parameters(String commandName, String[] args) {
            super(args, commandName, "<material-type-code> <material-code> <property-type-code>[=| ]<property-value>");
            if (this.getArgs().size() == 4) {
                this.propertyTypeCode = StringUtils.upperCase(this.getArgs().get(2));
                this.propertyValue = this.getArgs().get(3);
                return;
            }
            if (this.getArgs().size() == 3 && this.getArgs().get(1).indexOf(61) > 0) {
                String[] splitted = StringUtils.split(this.getArgs().get(2), "=", 2);
                this.propertyTypeCode = StringUtils.upperCase(splitted[0]);
                this.propertyValue = splitted[1];
                return;
            }
            System.err.println("Not all parameters have been specified.");
            this.printHelp(true);
        }

        public final String getMaterialTypeCode() {
            return StringUtils.upperCase(this.getArgs().get(0));
        }

        public final String getMaterialCode() {
            return StringUtils.upperCase(this.getArgs().get(1));
        }

        public final String getPropertyTypeCode() {
            return this.propertyTypeCode;
        }

        public final String getPropertyValue() {
            return this.propertyValue;
        }
    }
}

