/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.BaseExperiment;
import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.ListSet;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import ch.systemsx.cisd.lims.client.model.PropertiesDescriptor;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BaseExperimentTableModel
extends ModalTableModel {
    private final BaseExperiment[] experiments;
    private final ListSet properties;
    private final String[] columnsOrder;
    private final String header;
    private static final int FIXED_COLUMNS_NUMBER = 7;

    public BaseExperimentTableModel(BaseExperiment[] experiments, String header, boolean prettyMode) {
        super(prettyMode);
        this.experiments = experiments;
        this.header = header;
        this.properties = PropertiesDescriptor.createPropertiesListSet(experiments);
        this.columnsOrder = this.properties.getNamesOfNonEmptyColumns().toArray(new String[0]);
    }

    protected final Object getFixedValueAt(int rowIndex, int columnIndex) {
        assert (columnIndex < this.getFixedColumnsNumber());
        BaseExperiment experiment = this.experiments[rowIndex];
        switch (columnIndex) {
            case 0: {
                return experiment.getProject().getCode();
            }
            case 1: {
                return experiment.getCode();
            }
            case 2: {
                return experiment.isInvalidated();
            }
            case 3: {
                return experiment.getStudyObject().getCode();
            }
            case 4: {
                return experiment.getRegistrator();
            }
            case 5: {
                return experiment.getRegistrationDate();
            }
            case 6: {
                return experiment.getLastDataSetDate();
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    protected final String getPropertyLabel(int columnIndex) {
        String propertyCode = this.getPropertyCode(columnIndex);
        if (this.prettyMode) {
            return this.properties.getLabel(propertyCode);
        }
        return propertyCode;
    }

    private final int getPropertyIndex(int columnIndex) {
        return columnIndex - 7;
    }

    protected final int getFixedColumnsNumber() {
        return 7;
    }

    private final String getPropertyCode(int columnIndex) {
        int propertyIndex = this.getPropertyIndex(columnIndex);
        return this.columnsOrder[propertyIndex];
    }

    @Override
    public final String getColumnName(int columnIndex) {
        if (columnIndex < this.getFixedColumnsNumber()) {
            return this.getFixedColumnName(columnIndex);
        }
        return this.getPropertyLabel(columnIndex);
    }

    protected String getFixedColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.PROJECT_CODE.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.CODE.getName(this.prettyMode);
            }
            case 2: {
                return FieldName.INVALID.getName(this.prettyMode);
            }
            case 3: {
                return FieldName.STUDY_OBJECT.getName(this.prettyMode);
            }
            case 4: {
                return FieldName.REGISTRATOR.getName(this.prettyMode);
            }
            case 5: {
                return FieldName.REGISTRATION_DATE.getName(this.prettyMode);
            }
            case 6: {
                return FieldName.LAST_DATASET_DATE.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return Boolean.class;
            }
            case 4: {
                return Person.class;
            }
            case 5: 
            case 6: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public final int getColumnCount() {
        return this.getFixedColumnsNumber() + this.columnsOrder.length;
    }

    @Override
    public final String getHeader() {
        return this.header;
    }

    @Override
    public final int getRowCount() {
        return this.experiments.length;
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        this.assertColumnIndex(columnIndex);
        if (columnIndex < this.getFixedColumnsNumber()) {
            return this.getFixedValueAt(rowIndex, columnIndex);
        }
        String code = this.getPropertyCode(columnIndex);
        return this.properties.tryGetValueAt(code, rowIndex);
    }
}

