/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import ch.systemsx.cisd.lims.client.model.PlateBasicTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExperimentPlatesTableModel
extends ModalTableModel {
    private static final int EXTRA_FIXED_COLUMN_COUNT = 1;
    private final PlateBasicTableModel basicTable;
    private final Sample[] samples;

    public ExperimentPlatesTableModel(Sample[] samples, String header, boolean prettyMode) {
        super(prettyMode);
        this.basicTable = new PlateBasicTableModel(samples, header, prettyMode);
        this.samples = samples;
    }

    private int getLocalColumnIndex(int columnIndex) {
        return columnIndex - this.basicTable.getColumnCount();
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        if (columnIndex < this.basicTable.getColumnCount()) {
            return this.basicTable.getColumnClass(columnIndex);
        }
        return String.class;
    }

    @Override
    public final String getColumnName(int columnIndex) {
        this.assertColumnIndex(columnIndex);
        if (columnIndex < this.basicTable.getColumnCount()) {
            return this.basicTable.getColumnName(columnIndex);
        }
        int localColumnIndex = this.getLocalColumnIndex(columnIndex);
        return this.getFixedColumnName(localColumnIndex);
    }

    private String getFixedColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.PROCEDURE_TYPE.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("invalid table column index " + columnIndex);
    }

    @Override
    public final int getColumnCount() {
        return this.basicTable.getColumnCount() + 1;
    }

    @Override
    public final String getHeader() {
        return this.basicTable.getHeader();
    }

    @Override
    public final int getRowCount() {
        return this.basicTable.getRowCount();
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        this.assertColumnIndex(columnIndex);
        if (columnIndex < this.basicTable.getColumnCount()) {
            return this.basicTable.getValueAt(rowIndex, columnIndex);
        }
        Sample sample = this.samples[rowIndex];
        int localColumnIndex = this.getLocalColumnIndex(columnIndex);
        switch (localColumnIndex) {
            case 0: {
                return sample.getProcedure().getProcedureType().getCode();
            }
        }
        throw new IllegalArgumentException("invalid table column index " + columnIndex);
    }
}

