/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.Person;
import ch.systemsx.cisd.lims.base.Sample;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;
import ch.systemsx.cisd.lims.client.utilities.SampleDescriptor;
import java.util.Date;
import org.apache.commons.lang.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSampleBasicTableModel
extends ModalTableModel {
    private static final int COLUMN_COUNT = 7;
    private final Sample[] samples;
    private final String header;

    public GenericSampleBasicTableModel(Sample[] samples, String header, boolean prettyMode) {
        super(prettyMode);
        this.samples = samples;
        this.header = header;
    }

    protected static final String getSampleTypeCode(Sample sample) {
        return sample.getSampleType().getCode();
    }

    protected final Sample getSample(int rowIndex) {
        return this.samples[rowIndex];
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return Person.class;
            }
            case 4: {
                return Date.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public final String getHeader() {
        return this.header;
    }

    @Override
    public final int getRowCount() {
        return this.samples.length;
    }

    @Override
    public final String getColumnName(int columnIndex) {
        return this.getColumnDesc(columnIndex).getName(this.prettyMode);
    }

    protected FieldName getColumnDesc(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.CODE;
            }
            case 1: {
                return FieldName.TYPE_CODE;
            }
            case 2: {
                return FieldName.INVALID;
            }
            case 3: {
                return FieldName.REGISTRATOR;
            }
            case 4: {
                return FieldName.REGISTRATION_DATE;
            }
            case 5: {
                return FieldName.GENERATED_FROM;
            }
            case 6: {
                return FieldName.ORIGIN_GENERATED_FROM;
            }
        }
        throw new IllegalArgumentException("invalid table column index " + columnIndex);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.assertColumnIndex(columnIndex);
        Sample sample = this.getSample(rowIndex);
        switch (columnIndex) {
            case 0: {
                return SampleDescriptor.getSampleCode(sample);
            }
            case 1: {
                return GenericSampleBasicTableModel.getSampleTypeCode(sample);
            }
            case 2: {
                if (sample.getInvalidation() != null) {
                    return true;
                }
                return false;
            }
            case 3: {
                return sample.getRegistrator();
            }
            case 4: {
                return sample.getRegistrationDate();
            }
            case 5: {
                return SampleDescriptor.getSampleCode(sample.getGeneratedFrom());
            }
            case 6: {
                return ObjectUtils.equals(sample.getTop(), sample.getGeneratedFrom()) ? "" : SampleDescriptor.getSampleCode(sample.getTop());
            }
        }
        throw new IllegalArgumentException("invalid table column index " + columnIndex);
    }
}

