/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.model;

import ch.systemsx.cisd.lims.base.FieldName;
import ch.systemsx.cisd.lims.base.SearchHitDescription;
import ch.systemsx.cisd.lims.base.SearchResult;
import ch.systemsx.cisd.lims.client.model.ModalTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchTableModel
extends ModalTableModel {
    private final SearchResult searchResults;
    private final int firstSampleIndex;
    private final int firstMaterialIndex;
    private final int rowCount;
    private final String header;

    public SearchTableModel(SearchResult contacts, String header, boolean prettyMode) {
        super(prettyMode);
        this.searchResults = contacts;
        this.firstSampleIndex = this.searchResults.getExperiments().length;
        this.firstMaterialIndex = this.firstSampleIndex + this.searchResults.getSamples().length;
        this.rowCount = this.firstMaterialIndex + this.searchResults.getMaterials().length;
        this.header = header;
    }

    @Override
    public final int getColumnCount() {
        return 3;
    }

    @Override
    public final String getHeader() {
        return this.header;
    }

    @Override
    public final int getRowCount() {
        return this.rowCount;
    }

    @Override
    public final Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public final String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return FieldName.ENTITY_TYPE.getName(this.prettyMode);
            }
            case 1: {
                return FieldName.ENTITY.getName(this.prettyMode);
            }
            case 2: {
                return FieldName.HIT_DESCRIPTION.getName(this.prettyMode);
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    @Override
    public final Object getValueAt(int rowIndex, int columnIndex) {
        SearchHitDescription hitDescription;
        ENTITY_TYPE type = rowIndex < this.firstSampleIndex ? ENTITY_TYPE.EXPERIMENT : (rowIndex < this.firstMaterialIndex ? ENTITY_TYPE.SAMPLE : ENTITY_TYPE.MATERIAL);
        switch (type) {
            case EXPERIMENT: {
                hitDescription = this.searchResults.getExperiments()[rowIndex];
                break;
            }
            case SAMPLE: {
                hitDescription = this.searchResults.getSamples()[rowIndex - this.firstSampleIndex];
                break;
            }
            case MATERIAL: {
                hitDescription = this.searchResults.getMaterials()[rowIndex - this.firstMaterialIndex];
                break;
            }
            default: {
                throw new Error();
            }
        }
        switch (columnIndex) {
            case 0: {
                return type.name();
            }
            case 1: {
                return hitDescription.getEntity();
            }
            case 2: {
                return hitDescription.getHitDescription();
            }
        }
        throw new IllegalArgumentException("columnIndex '" + columnIndex + "' not allowed.");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ENTITY_TYPE {
        EXPERIMENT,
        SAMPLE,
        MATERIAL;

    }
}

