/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.client.output;

import ch.systemsx.cisd.common.io.ILinePrinter;
import ch.systemsx.cisd.lims.client.output.IOutputPrinter;
import ch.systemsx.cisd.lims.client.table.ITableModel;
import ch.systemsx.cisd.lims.client.table.TableRenderer;

public class TSVOutputPrinter
implements IOutputPrinter {
    private static final String HEADER_PREFIX = "#";
    private static final char DELIMITER = '\t';
    private static final String PREFIX = "#\t";
    private final ILinePrinter printer;

    public TSVOutputPrinter(ILinePrinter printer) {
        assert (printer != null) : "Unspecified line printer.";
        this.printer = printer;
    }

    public final void printKeyValuePair(String key, String valueOrNull) {
        this.printer.println(PREFIX + key + '\t' + (valueOrNull == null ? "" : valueOrNull));
    }

    public final void printTableModel(ITableModel tableModel, String tableComment) {
        this.printer.println(HEADER_PREFIX);
        StringBuilder builder = new StringBuilder();
        String delimiter = HEADER_PREFIX;
        int numberOfColumns = tableModel.getColumnCount();
        int i = 0;
        while (i < numberOfColumns) {
            builder.append(delimiter).append(tableModel.getColumnName(i));
            delimiter = Character.toString('\t');
            ++i;
        }
        this.printer.println(builder.toString());
        int n = tableModel.getRowCount();
        int i2 = 0;
        while (i2 < n) {
            builder.setLength(0);
            int j = 0;
            while (j < numberOfColumns) {
                Object value = tableModel.getValueAt(i2, j);
                Class<?> clazz = tableModel.getColumnClass(j);
                builder.append(TableRenderer.render(clazz, value, "").trim());
                if (j < numberOfColumns - 1) {
                    builder.append('\t');
                }
                ++j;
            }
            this.printer.println(builder.toString());
            ++i2;
        }
    }
}

