/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.lims.server.business;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.lims.server.business.IScreeningProcessStrategy;
import ch.systemsx.cisd.lims.server.business.Session;
import ch.systemsx.cisd.lims.server.business.bo.IBusinessObjectFactory;
import ch.systemsx.cisd.lims.server.business.bo.ISampleBO;
import ch.systemsx.cisd.lims.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.lims.server.dto.ProcedureDTO;
import ch.systemsx.cisd.lims.server.dto.SampleDTO;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScreeningProcessStrategy
implements IScreeningProcessStrategy {
    protected final IDAOFactory daoFactory;
    protected final IBusinessObjectFactory boFactory;
    protected final Session session;

    public AbstractScreeningProcessStrategy(IDAOFactory daoFactory, IBusinessObjectFactory boFactory, Session session) {
        assert (daoFactory != null) : "Given DAO factory can not be null.";
        assert (boFactory != null) : "Given business object factory can not be null.";
        assert (session != null) : "Given session can not be null.";
        this.daoFactory = daoFactory;
        this.boFactory = boFactory;
        this.session = session;
    }

    protected static final boolean containsProcedure(List<ProcedureDTO> procedures, Long procedureId) {
        assert (procedures != null) : "Given procedure list can not be null.";
        assert (procedureId != null) : "Given procedure id can not be null.";
        for (ProcedureDTO procedureDTO : procedures) {
            if (!procedureDTO.getId().equals(procedureId)) continue;
            return true;
        }
        return false;
    }

    protected SampleDTO tryToGetSampleWithProperties(String sampleCode) throws UserFailureException {
        assert (sampleCode != null) : "Unspecified sample code.";
        SampleDTO sample = this.daoFactory.getSampleDAO().tryFindSampleByCode(sampleCode);
        if (sample == null) {
            return null;
        }
        return this.enrichWithProperties(sample);
    }

    protected SampleDTO enrichWithProperties(SampleDTO sample) {
        ISampleBO sampleBO = this.boFactory.createSampleBO(this.session);
        sampleBO.setSample(sample);
        sampleBO.enrichWithProperties();
        return sampleBO.getSample();
    }
}

